<?php

declare(strict_types = 1);

namespace Internetgalerie\IgFormlog\Domain\Model;

/*
 * This file is part of the Pagemachine TYPO3 Formlog project.
 */

use Internetgalerie\IgFormlog\Domain\Data\JsonData;
use Internetgalerie\IgFormlog\Domain\Model\FormLogEntry\Page;
use TYPO3\CMS\Core\Site\Entity\SiteInterface;
use TYPO3\CMS\Core\Site\Entity\SiteLanguage;
use TYPO3\CMS\Core\Site\SiteFinder;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/**
 * A form log entry
 */
class FormLogEntry extends AbstractEntity
{
    /**
     * @var Page|null
     */
    public ?Page $page = null;

    /**
     * @var \DateTime|null
     */
    public ?\DateTime $submissionDate = null;

    /**
     * @var int|null
     */
    public ?int $language = null;

    /**
     * @var string
     */
    public string $identifier = '';

    /**
     * @var JsonData|null
     */
    public ?JsonData $data = null;

    /**
     * @var JsonData|null
     */
    public ?JsonData $finisherVariables = null;

    public function getSiteLanguage(): ?SiteLanguage
    {
        $site = $this->getSite();

        if ($site === null) {
            return null;
        }
        return $this->getSite()->getLanguageById($this->language);
    }

    private function getSite(): ?SiteInterface
    {
        $siteFinder = GeneralUtility::makeInstance(SiteFinder::class);

        if ($this->page === null) {
            return null;
        }

        return $siteFinder->getSiteByPageId($this->page->uid);
    }
}
