<?php
defined('TYPO3') or die();

return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_formlog/Resources/Private/Language/locallang_db.xlf:tx_igformlog_entries',
        'label' => 'uid',
        'default_sortby' => 'crdate DESC',
        'crdate' => 'crdate',
        'tstamp' => 'tstamp',
        'delete' => 'deleted',
        'security' => [
            'ignorePageTypeRestriction' => true,
        ],
        'readOnly' => true,
        'iconfile' => 'EXT:ig_formlog/Resources/Public/Icons/tx_igformlog_entries.svg',
    ],
    'types' => [
        '0' => [
            'showitem' => 'crdate, language, identifier, data, finisher_variables',
        ],
    ],
    'columns' => [
        'pid' => [
            'config' => [
                'type' => 'passthrough',
                'foreign_table' => 'pages',
            ],
        ],
        'crdate' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.creationDate',
            'config' => [
                'type' => 'none',
                'format' => 'datetime',
                'eval' => 'datetime',
            ],
        ],
        'language' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_formlog/Resources/Private/Language/locallang_db.xml:tx_igformlog_entries.language',
            'config' => [
                'type' => 'language',
                'readOnly' => true,
            ],
        ],
        'identifier' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_formlog/Resources/Private/Language/locallang_db.xml:tx_igformlog_entries.identifier',
            'config' => [
                'type' => 'none',
            ],
        ],
        'data' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_formlog/Resources/Private/Language/locallang_db.xml:tx_igformlog_entries.data',
            'config' => [
                'type' => 'text',
                'renderType' => 'jsonData',
                'readOnly' => true,
            ],
        ],
        'finisher_variables' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_formlog/Resources/Private/Language/locallang_db.xml:tx_igformlog_entries.finisher_variables',
            'config' => [
                'type' => 'text',
                'renderType' => 'jsonData',
                'readOnly' => true,
            ],
        ],
    ],
];
