<?php

declare(strict_types=1);

namespace Internetgalerie\IgFrontendUser\Domain\Repository;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * A Frontend User Group Repository
 */
class FrontendUserGroupRepository extends Repository
{
    public function setStoragePageId(int $storagePageId): void
    {
        $this->initDefaultQuerySettings();
        $this->defaultQuerySettings->setStoragePageIds([$storagePageId]);
    }
    public function setRespectStoragePage(bool $respectStoragePage): void
    {
        $this->initDefaultQuerySettings();
        $this->defaultQuerySettings->setRespectStoragePage($respectStoragePage);
    }
    protected function initDefaultQuerySettings()
    {
        if ($this->defaultQuerySettings === null) {
            $this->defaultQuerySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);
        }
    }
}
