<?php
namespace Internetgalerie\IgFrontendUser\Domain\Validator;

use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser;
use TYPO3\CMS\Extbase\Error\Error;
use TYPO3\CMS\Extbase\Validation\Validator\AbstractValidator;

class FrontendUserRegistrationValidator extends AbstractValidator
{
    protected function isValid(mixed $frontendUser): void
    {
        if (!$frontendUser instanceof FrontendUser) {
            $this->addError('The given object is not a FrontendUser.', 1262341470);
            return;
        }
        if($frontendUser->getUsername() == '') {
            $this->result->forProperty('username')->addError(
                new Error('No username', 1638362238)
            );
        }
        if(!$frontendUser->getUsergroup()->count()) {
            $this->result->forProperty('usergroup')->addError(
                new Error('No usergroup', 1638362239)
            );
        }
    }
}
