<?php
use TYPO3\CMS\Extbase\Utility\ExtensionUtility;
use Internetgalerie\IgFrontendUser\Controller\FrontendUserController;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Imaging\IconRegistry;
use TYPO3\CMS\Core\Imaging\IconProvider\SvgIconProvider;

defined('TYPO3') or die();

call_user_func(static function() {
    ExtensionUtility::configurePlugin(
        'IgFrontendUser',
        'Admin',
        [
            FrontendUserController::class => 'list, show, new, create, edit, update, delete, confirmDelete'
        ],
        // non-cacheable actions
        [
            FrontendUserController::class => 'list, show, new, create, edit, update, delete, confirmDelete'
        ]
    );

    ExtensionUtility::configurePlugin(
        'IgFrontendUser',
        'ChangePassword',
        [
            FrontendUserController::class => 'editMyPassword, updateMyPassword'
        ],
        // non-cacheable actions
        [
            FrontendUserController::class => 'editMyPassword, updateMyPassword'
        ]
    );

    // wizards
    ExtensionManagementUtility::addPageTSConfig(
        'mod {
            wizards.newContentElement.wizardItems.plugins {
                elements {
                    admin {
                        iconIdentifier = ig_frontend_user-plugin-admin
                        title = LLL:EXT:ig_frontend_user/Resources/Private/Language/locallang_db.xlf:tx_ig_frontend_user_admin.title
                        description = LLL:EXT:ig_frontend_user/Resources/Private/Language/locallang_db.xlf:tx_ig_frontend_user_admin.description
                        tt_content_defValues {
                            CType = list
                            list_type = igfrontenduser_admin
                        }
                    }
                    changepassword {
                        iconIdentifier = ig_frontend_user-plugin-changepassword
                        title = LLL:EXT:ig_frontend_user/Resources/Private/Language/locallang_db.xlf:tx_ig_frontend_user_changepassword.title
                        description = LLL:EXT:ig_frontend_user/Resources/Private/Language/locallang_db.xlf:tx_ig_frontend_user_changepassword.description
                        tt_content_defValues {
                            CType = list
                            list_type = igfrontenduser_changepassword
                        }
                    }
                }
                show = *
            }
       }'
    );

    $iconRegistry = GeneralUtility::makeInstance(IconRegistry::class);
    $iconRegistry->registerIcon(
        'ig_frontend_user-plugin-admin',
        SvgIconProvider::class,
        ['source' => 'EXT:ig_frontend_user/Resources/Public/Icons/ig_frontend_user-plugin-admin.svg']
    );
    $iconRegistry->registerIcon(
        'ig_frontend_user-plugin-changepassword',
        SvgIconProvider::class,
        ['source' => 'EXT:ig_frontend_user/Resources/Public/Icons/ig_frontend_user-plugin-changepassword.svg']
    );
});
