<?php
namespace Internetgalerie\IgFrontendUser\Domain\Validator;

use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser;
use TYPO3\CMS\Core\Crypto\PasswordHashing\PasswordHashFactory;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Error\Error;
use TYPO3\CMS\Extbase\Validation\Validator\AbstractValidator;

class OldPasswordValidator extends AbstractValidator
{
    protected function isValid(mixed $frontendUser): void
    {
        if (!$frontendUser instanceof FrontendUser) {
            $this->addError('The given object is not a FrontendUser.', 1262341470);
            return;
        }
        if($frontendUser->getOldPassword() == '') {
            $this->result->forProperty('oldPassword')->addError(
                new Error('No old password', 1638362260)
            );
        }

        // Check the entered old password with hash saved in database
        $passwordHash = $frontendUser->_getCleanProperty('password');
        $success = GeneralUtility::makeInstance(PasswordHashFactory::class)
            ->get($passwordHash, 'FE') # or getDefaultHashInstance($mode)
            ->checkPassword($frontendUser->getOldPassword(), $passwordHash);

        if(!$success) {
            $this->result->forProperty('oldPassword')->addError(
                new Error('Old password wrong', 1638362261)
            );
        }
    }
}
