<?php
namespace Internetgalerie\IgFrontendUser\Domain\Validator;

use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser;
use TYPO3\CMS\Extbase\Error\Error;
use TYPO3\CMS\Extbase\Validation\Validator\AbstractValidator;

class PasswordRepeatValidator extends AbstractValidator
{
    protected function isValid(mixed $password): void
    {
        if (empty($password) || !isset($password['0'])  || $password['0'] === null || $password['0'] === '') {
            return;
        }
        if (!isset($password['1'])  || $password['1'] === null || $password['1'] === '') {
            $this->result->forProperty('passwordRepeat')->addError(
                new Error('No password confirmation', 1638362241)
            );
        }
        $passwordText = $password['0'];
        $passwordRepeatText = $password['1'];

        if ($passwordText !== $passwordRepeatText) {
            $this->result->forProperty('password')->addError(
                new Error('The passwords don\'t match', 1638362242)
            );
            $this->result->forProperty('passwordRepeat')->addError(
                new Error('The passwords don\'t match', 1638362243)
            );
        }
    }
}
