<?php
namespace Internetgalerie\IgFrontendUser\Domain\Validator;

use TYPO3\CMS\Extbase\Error\Error;
use TYPO3\CMS\Extbase\Validation\Validator\AbstractValidator;

class PasswordValidator extends AbstractValidator
{
    protected static $passwordMinLength = 8;
    
    protected function isValid(mixed $password): void
    {
        if (empty($password) || !isset($password['0']) || $password['0'] === null || $password['0'] === '') {
            return;
        }
        $passwordText = $password['0'];
        if(strlen($passwordText) < static::$passwordMinLength) {
            $this->result->forProperty('password')->addError(
                new Error('Password too short, must be minimum ' . static::$passwordMinLength . ' characters', 1638362246)
            );
        }
    }
}
