<?php

declare(strict_types=1);

namespace Internetgalerie\IgFrontendUser\Event;

use TYPO3\CMS\Extbase\Persistence\Generic\Query;

final class AddFrontendUserConstraintsEvent {

    private Query $query;
    private array $search;
    private array $settings;
    private array $constraints = [];

    public function __construct(Query $query, array $search, array $settings)
    {
        $this->query = $query;
        $this->search = $search;
        $this->settings = $settings;
    }

    public function getQuery()
    {
        return $this->query;
    }

    public function getSearch()
    {
        return $this->search;
    }

    public function getSettings()
    {
        return $this->settings;
    }

    public function getConstraints()
    {
        return $this->constraints;
    }

    public function setConstraints(array $constraints)
    {
        return $this->constraints = $constraints;
    }
}