<?php
defined('TYPO3') or die();

call_user_func(static function() {
    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::configurePlugin(
        'IgFrontendUser',
        'Admin',
        [
            \Internetgalerie\IgFrontendUser\Controller\FrontendUserController::class => 'list, show, new, create, edit, update, delete, confirmDelete'
        ],
        // non-cacheable actions
        [
            \Internetgalerie\IgFrontendUser\Controller\FrontendUserController::class => 'list, show, new, create, edit, update, delete, confirmDelete'
        ]
    );

    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::configurePlugin(
        'IgFrontendUser',
        'ChangePassword',
        [
            \Internetgalerie\IgFrontendUser\Controller\FrontendUserController::class => 'editMyPassword, updateMyPassword'
        ],
        // non-cacheable actions
        [
            \Internetgalerie\IgFrontendUser\Controller\FrontendUserController::class => 'editMyPassword, updateMyPassword'
        ]
    );

    // wizards
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPageTSConfig(
        'mod {
            wizards.newContentElement.wizardItems.plugins {
                elements {
                    admin {
                        iconIdentifier = ig_frontend_user-plugin-admin
                        title = LLL:EXT:ig_frontend_user/Resources/Private/Language/locallang_db.xlf:tx_ig_frontend_user_admin.title
                        description = LLL:EXT:ig_frontend_user/Resources/Private/Language/locallang_db.xlf:tx_ig_frontend_user_admin.description
                        tt_content_defValues {
                            CType = list
                            list_type = igfrontenduser_admin
                        }
                    }
                    changepassword {
                        iconIdentifier = ig_frontend_user-plugin-changepassword
                        title = LLL:EXT:ig_frontend_user/Resources/Private/Language/locallang_db.xlf:tx_ig_frontend_user_changepassword.title
                        description = LLL:EXT:ig_frontend_user/Resources/Private/Language/locallang_db.xlf:tx_ig_frontend_user_changepassword.description
                        tt_content_defValues {
                            CType = list
                            list_type = igfrontenduser_changepassword
                        }
                    }
                }
                show = *
            }
       }'
    );

    $iconRegistry = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\TYPO3\CMS\Core\Imaging\IconRegistry::class);
    $iconRegistry->registerIcon(
        'ig_frontend_user-plugin-admin',
        \TYPO3\CMS\Core\Imaging\IconProvider\SvgIconProvider::class,
        ['source' => 'EXT:ig_frontend_user/Resources/Public/Icons/ig_frontend_user-plugin-admin.svg']
    );
    $iconRegistry->registerIcon(
        'ig_frontend_user-plugin-changepassword',
        \TYPO3\CMS\Core\Imaging\IconProvider\SvgIconProvider::class,
        ['source' => 'EXT:ig_frontend_user/Resources/Public/Icons/ig_frontend_user-plugin-changepassword.svg']
    );
});
