<?php

declare(strict_types=1);

namespace Internetgalerie\IgFrontendUser\Event;

use TYPO3\CMS\Extbase\Persistence\Generic\Query;

final class AddFrontendUserConstraintsEvent {

    private array $constraints = [];

    public function __construct(private readonly Query $query, private readonly array $search, private readonly array $settings)
    {
    }

    public function getQuery()
    {
        return $this->query;
    }

    public function getSearch()
    {
        return $this->search;
    }

    public function getSettings()
    {
        return $this->settings;
    }

    public function getConstraints()
    {
        return $this->constraints;
    }

    public function setConstraints(array $constraints)
    {
        return $this->constraints = $constraints;
    }
}