<?php

declare(strict_types=1);

namespace Internetgalerie\IgFrontendUser\Utility;

use Internetgalerie\IgFrontendUser\Domain\Repository\FrontendUserRepository;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManager;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;

/**
 * SecurityUtility
 */
class SecurityUtility implements SingletonInterface
{

    private ?int $feAdminUid = null;

    protected static $frontendUserGroupIds = null;
    /**                                                                                                                     
     * ConfigurationManager                                                                                                 
     *                                                                                                                      
     * @var ConfigurationManager                                                                                            
     */
    protected $configurationManager = null;

    /**                                                                                                                     
     * FrontendUserRepository                                                                                               
     *                                                                                                                      
     * @var FrontendUserRepository                                                                                          
     */
    protected $frontendUserRepository = null;


    /**
     * @param ConfigurationManager $configurationManager
     * @param FrontendUserRepository $frontendUserRepository
     */
    public function __construct(ConfigurationManager $configurationManager, FrontendUserRepository $frontendUserRepository)
    {
        $this->context = GeneralUtility::makeInstance(Context::class);
        $this->configurationManager = $configurationManager;
        //Admin Frontend UserGroup UID[plugin.tx_igfrontenduser.settings.adminFrontendUserGroupUid] 
        $this->feAdminUid = (int) $this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT)['plugin.']['tx_igfrontenduser.']['settings.']['adminFrontendUserGroupUid'] ?? $this->feAdminUid;
        $this->frontendUserRepository = $frontendUserRepository;
    }

    public function getFrontendUserGroupIds()
    {
        if (static::$frontendUserGroupIds === null) {
            static::$frontendUserGroupIds = [];
            foreach ($this->context->getPropertyFromAspect('frontend.user', 'groupIds') as $groupId) {
                if ($groupId > 0) {
                    static::$frontendUserGroupIds[] = $groupId;
                }
            }
        }
        return static::$frontendUserGroupIds;
    }

    
    /**
     * has the current frontend user admin rights
     */
    public function isAdmin(): bool
    {
        $frontendUserGroupIds = $this->getFrontendUserGroupIds();
        return in_array($this->feAdminUid, $frontendUserGroupIds);
    }

    public function getFrontendUserId()
    {
        return $this->context->getPropertyFromAspect('frontend.user', 'id');
    }

    public function getFrontendUser()
    {
        if ($this->frontendUser === null) {
            //$this->frontendUserRepository->setRespectStoragePage(false);
            $frontendUserId = $this->getFrontendUserId();
            if ($frontendUserId > 0) {
                $this->frontendUser = $this->frontendUserRepository->findOneBy(['uid' => $frontendUserId]);
            }
        }
        return $this->frontendUser;
    }

    public function getFrontendUserContact()
    {
        if ($this->contact === null) {
            $this->getFrontendUser();
            if ($this->frontendUser instanceof FrontendUser && method_exists($this->frontendUser, 'getContact')) {
                $this->contact = $this->frontendUser->getContact();
            } else {
                $this->contact = $this->frontendUser;
            }
        }
        return $this->contact;
    }

}