<?php

declare(strict_types=1);

namespace Ig\IgGeodata\Domain\Repository;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for Plzs
 */
class PlzRepository extends Repository
{
    public function initializeObject(): void
    {
        $querySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }

    public function findNearestPlz(int $plz)
    {
        if ($plz == 0) {
            return false;
        }
        
        $entry = $this->findOneBy([
            'plz' => $plz,
        ]);
        if ($entry instanceof $this->objectType) {
            return $entry;
        }
        
        $dataMapper = GeneralUtility::makeInstance(DataMapper::class);
        $tablename = $dataMapper->getDataMap($this->objectType)
->getTableName();
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($tablename);
        //SELECT * FROM tx_iggeodata_domain_model_plz ORDER BY abs(8000-plz) LIMIT 1;

        // sinnvoll? Bei z.B. 8000 sollen 7xxx nicht berücksichtigt werden, da wohl weiter weg (findet aber eh die ueber 8000)
        // only search for postcodes with the same first and second digits
        $firstDigits = intval($plz / 100);
        // select a computed distance column and order by that alias to avoid quoting issues with parameter expressions in ORDER BY
        $result = $queryBuilder
            ->select('*')
            ->addSelectLiteral('ABS(' . $plz . ' - plz) AS distance')
            ->from($tablename)
            ->where(
                $queryBuilder->expr()->and(
                    $queryBuilder->expr()->gte('plz', $firstDigits * 100),
                    $queryBuilder->expr()->lt('plz', ($firstDigits + 1) * 100)
                )
            )
            ->orderBy('distance')
            ->setMaxResults(1)
            ->executeQuery();
        $row = $result->fetchAssociative();
        if ($row === false) {
            return $row;
        }
        unset($row['distance']);
        $entry = $dataMapper->map($this->objectType, [$row])[0];
        return $entry;
    }
}
