<?php

namespace Ig\IgGeodata\Utility;

use Exception;
use Soapclient;
use TYPO3\CMS\Core\SingletonInterface;

/*
  Use:
  // Unternehmens-ID (UID) Hack
  $bfsUid = GeneralUtility::makeInstance(\Ig\IgGeodata\Utility\BfsUidUtility::class);

  $uidArray = $bfsUid->testUid($this->address['be_uid']['value'], $this->address['be_firma']['value']);
  if ($uidArray['error']) {

  }
  if ($this->address['be_uid']['value'] > 0) {
      $this->address['be_uid']['format'] = $this->formatUid($this->address['be_uid']['value']);
  }
 */

class BfsUidUtility implements SingletonInterface
{
    public function formatUid($uid)
    {
        $uid = preg_replace('/[^0-9]/', '', (string) $uid);
        return 'CHE-' . number_format($uid, 0, ',', '.');
    }
    public function testUid($uid, $firma)
    {
        $webServiceUrl = 'https://www.uid-wse.admin.ch/V3.0/PublicServices.svc?wsdl';
        $client = new Soapclient($webServiceUrl);
        $uid = preg_replace('/[^0-9]/', '', (string) $uid);
        if (!$uid) {
            return [
                'error' => 0,
                'code' => 0,
                'data' => '',
            ];
        }
        if (strlen($uid) != 9) {
            return [
                'error' => 1,
                'code' => 'invalid',
                'data' => '',
            ];
        }
        $organisation = [
            'organisation' => [
                'organisationIdentification' => [
                    'uid' => [
                        'uidOrganisationIdCategorie' => 'CHE',
                        'uidOrganisationId' => $uid,
                    ],

                    //  'organisationName' => $organisationName
                ],
            ],
        ];
        try {
            $res = $client->Search([
                'searchParameters' => $organisation,
            ]);
            $anzahlResultate = count($res->SearchResult -> organisationType);
            if ($anzahlResultate != 1) {
                return [
                    'error' => 1,
                    'code' => 'several',
                    'data' => '',
                ];
            }
            $data = $res->SearchResult->organisationType;
            $org = trim((string) $data->organisation->organisationIdentification->organisationName);

            if (strcmp(strtolower($org), strtolower(trim((string) $firma))) != 0) {
                return [
                    'error' => 1,
                    'code' => 'company',
                    'data' => $org,
                ];
            }
            return [
                'error' => 0,
                'code' => '0',
                'data' => $org,
            ];
        } catch (Exception) {
        }
        return [
            'error' => 1,
            'code' => 'unknown',
            'data' => '',
        ];
    }
    public function fetchUid($address)
    {
        /*
          Format von $address
          [
          'organisationName'=> 'Bethesda-Spital AG',
          'country' => 'CH',
          'town' => 'Basel',
          'zip' => '4020',
          'street' => 'Gellertstr.',
          'houseNumber' => '144'
          ]
         */

        $webServiceUrl = 'https://www.uid-wse.admin.ch/V3.0/PublicServices.svc?wsdl';
        $client = new Soapclient($webServiceUrl);
        //    $uid=preg_replace('/[^0-9]/','',$uid);
        /*
          $organisationName='Internetgalerie AG';
          $street='Aarestrasse 32';
          $houseNumber='32';
          $zip='3600';
          $town='Thun';
          $kanton='BE'; //zn_code static_country_zones
          $country='CH';
        */
        $organisationName = $address['organisationName'];
        $street = $address['street'];
        $houseNumber = $address['houseNumber'];
        $zip = $address['zip'];
        $town = $address['town'];
        //    $kanton='BE'; //zn_code static_country_zones
        $country = $address['country'];
        $kanton = '';
        if ($organisationName == '') {
            return '';
        }
        $organisation = [
            //      'cantonAbbreviationMainAddress' => $kanton,
            'uidregInformation' => [
                'uidregStatusEnterpriseDetail' => '3', //Detaillierter Status des Eintrags im UID-Register 3=definitiv
            ],
            'commercialRegisterInformation' => [
                'commercialRegisterEntryStatus' => '1', // HR-Stauts 1=aktiv
            ],
            'organisation' => [
                'organisationIdentification' => [
                    'organisationName' => $organisationName,
                ],

                'contact' => [
                    'address' => [
                        'postalAdress' => [
                            'adressInformation' => [
                                'street' => $street,
                                'houseNumber' => $houseNumber,
                                'town' => $town,
                                'swissZipCode' => $zip,
                                'country' => [
                                    'countryIdISO2' => $country,
                                ],
                            ],
                        ],
                    ],
                ],
            ],

        ];
        try {
            $res = $client->Search([
                'searchParameters' => $organisation,
                'maxNumberOfRecords' => '2',
                'searchMode' => 'Normal',
            ]);
            $anzahlResultate = count($res->SearchResult->organisationType);
            $data = $res->SearchResult->organisationType;
            if ($anzahlResultate == 1) {
                return $data->organisation->organisationIdentification->uid->uidOrganisationId;
            }

            return '';
        } catch (Exception) {
            return '';
        }
        /*
          echo('Anzahl='. $anzahlResultate .'<br />');
          ini_set('xdebug.var_display_max_depth', 10);
          var_dump($res->SearchResult);
          if($anzahlResultate!=1)
          return [ 'error' => 1, 'code' => 'several', 'data' => '' ];
          $org= trim((string) $data->organisation->organisationIdentification->organisationName);
          if (strcmp( strtolower($org), strtolower(trim($organisationName)))!=0)
          return [ 'error' => 1, 'code' => 'company', 'data' => $org ];
        */
    }
}
