<?php

declare(strict_types=1);

namespace Ig\IgGeodata\Utility;

use Ig\IgGeodata\Domain\Repository\CountryRepository;
use TYPO3\CMS\Core\SingletonInterface;

class CountryUtility implements SingletonInterface
{
    /**
     * countryRepository
     *
     * @var CountryRepository
     */
    protected $countryRepository = null;

    /**
     * @param CountryRepository $countryRepository country repository
     */
    public function injectCountryRepository(CountryRepository $countryRepository): void
    {
        $this->countryRepository = $countryRepository;
    }

    public function findByCountryName($countryName)
    {
        return $this->countryRepository->findOneBy([
            'name' => $countryName,
        ]);
    }
    
    public function latlngByCountryIso2Code($countryIso2Code)
    {
        $entry = $this->countryRepository->findOneBy([
            'iso2Code' => $countryIso2Code,
        ]);
        return is_object($entry) ? $entry->getLongitude() . ',' . $entry->getLatitude() : null;
    }
}
