<?php

declare(strict_types=1);

namespace Ig\IgGeodata\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/**
 * This file is part of the "Geodaten" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2022 Daniel Abplanalp <typo3@internetgalerie.ch>, Internetgalerie AG
 */

class Country extends AbstractEntity
{
    /**
     * iso2Code
     *
     * @var string
     */
    protected $iso2Code = null;

    /**
     * latitude
     *
     * @var string
     */
    protected $latitude = null;

    /**
     * longitude
     *
     * @var string
     */
    protected $longitude = null;

    /**
     * name
     *
     * @var string
     */
    protected $name = null;

    /**
     * Returns the iso2Code
     *
     * @return string
     */
    public function getIso2Code()
    {
        return $this->iso2Code;
    }

    /**
     * Sets the iso2Code
     */
    public function setIso2Code(string $iso2Code): void
    {
        $this->iso2Code = $iso2Code;
    }

    /**
     * Returns the latitude
     *
     * @return string
     */
    public function getLatitude()
    {
        return $this->latitude;
    }

    /**
     * Sets the latitude
     */
    public function setLatitude(string $latitude): void
    {
        $this->latitude = $latitude;
    }

    /**
     * Returns the longitude
     *
     * @return string
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * Sets the longitude
     */
    public function setLongitude(string $longitude): void
    {
        $this->longitude = $longitude;
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }
}
