<?php

declare(strict_types=1);

namespace Ig\IgGeodata\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/**
 * This file is part of the "Geodaten" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2022 Daniel Abplanalp <typo3@internetgalerie.ch>, Internetgalerie AG
 */

class Plz extends AbstractEntity
{
    /**
     * kanton
     *
     * @var string
     */
    protected $kanton = null;

    /**
     * ortsname
     *
     * @var string
     */
    protected $ortsname = null;

    /**
     * gdenr
     *
     * @var string
     */
    protected $gdenr = null;

    /**
     * gdename
     *
     * @var string
     */
    protected $gdename = null;

    /**
     * plz
     *
     * @var int
     */
    protected $plz = null;

    /**
     * plzname
     *
     * @var string
     */
    protected $plzname = null;

    /**
     * latitude
     *
     * @var string
     */
    protected $latitude = null;

    /**
     * longitude
     *
     * @var string
     */
    protected $longitude = null;

    /**
     * Returns the kanton
     *
     * @return string
     */
    public function getKanton()
    {
        return $this->kanton;
    }

    /**
     * Sets the kanton
     */
    public function setKanton(string $kanton): void
    {
        $this->kanton = $kanton;
    }

    /**
     * Returns the ortsname
     *
     * @return string
     */
    public function getOrtsname()
    {
        return $this->ortsname;
    }

    /**
     * Sets the ortsname
     */
    public function setOrtsname(string $ortsname): void
    {
        $this->ortsname = $ortsname;
    }

    /**
     * Returns the gdenr
     *
     * @return string
     */
    public function getGdenr()
    {
        return $this->gdenr;
    }

    /**
     * Sets the gdenr
     */
    public function setGdenr(string $gdenr): void
    {
        $this->gdenr = $gdenr;
    }

    /**
     * Returns the gdename
     *
     * @return string
     */
    public function getGdename()
    {
        return $this->gdename;
    }

    /**
     * Sets the gdename
     */
    public function setGdename(string $gdename): void
    {
        $this->gdename = $gdename;
    }

    /**
     * Returns the plz
     *
     * @return int
     */
    public function getPlz()
    {
        return $this->plz;
    }

    /**
     * Sets the plz
     */
    public function setPlz(int $plz): void
    {
        $this->plz = $plz;
    }

    /**
     * Returns the plzname
     *
     * @return string
     */
    public function getPlzname()
    {
        return $this->plzname;
    }

    /**
     * Sets the plzname
     */
    public function setPlzname(string $plzname): void
    {
        $this->plzname = $plzname;
    }

    /**
     * Returns the latitude
     *
     * @return string
     */
    public function getLatitude()
    {
        return $this->latitude;
    }

    /**
     * Sets the latitude
     */
    public function setLatitude(string $latitude): void
    {
        $this->latitude = $latitude;
    }

    /**
     * Returns the longitude
     *
     * @return string
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * Sets the longitude
     */
    public function setLongitude(string $longitude): void
    {
        $this->longitude = $longitude;
    }
}
