<?php

declare(strict_types=1);

namespace Ig\IgGeodata\Utility;

use Ig\IgGeodata\Domain\Repository\PlzRepository;
use TYPO3\CMS\Core\SingletonInterface;

/*
Use:
// Unternehmens-ID (UID) Hack
$bfsUid = GeneralUtility::makeInstance(\Ig\IgGeodata\Utility\PlzUtility::class);
 */
class PlzUtility implements SingletonInterface
{
    /**
     * plzRepository
     *
     * @var PlzRepository
     */
    protected $plzRepository = null;

    /**
     * @param PlzRepository $plzRepository [description]
     */
    public function injectPlzRepository(PlzRepository $plzRepository): void
    {
        $this->plzRepository = $plzRepository;
    }

    public function findByPlz($plz)
    {
        return $this->plzRepository->findOneBy([
            'plz' => $plz,
        ]);
    }

    public function findNearestByPlz($plz)
    {
        return $this->plzRepository->findNearestPlz($plz);
    }
    
    public function kantonByPlz($plz)
    {
        $entry = $this->plzRepository->findOneBy([
            'plz' => $plz,
        ]);
        return is_object($entry) ? $entry->getKanton() : null;
    }
    
    public function latlngByPlz($plz)
    {
        $entry = $this->plzRepository->findOneBy([
            'plz' => $plz,
        ]);
        return is_object($entry) ? $entry->getLongitude() . ',' . $entry->getLatitude() : null;
    }
    
    public function ortsnameByPlz($plz)
    {
        $entry = $this->plzRepository->findOneBy([
            'plz' => $plz,
        ]);
        return is_object($entry) ? $entry->getOrtsname() : null;
    }
    
    public function gemeindenameByPlz($plz)
    {
        $entry = $this->plzRepository->findOneBy([
            'plz' => $plz,
        ]);
        return is_object($entry) ? $entry->getGdename() : null;
    }
    
    public function bfsnrByPlz($plz)
    {
        $entry = $this->plzRepository->findOneBy([
            'plz' => $plz,
        ]);
        return is_object($entry) ? $entry->getGdenr() : null;
    }
}
