<?php

namespace Ig\IgGooglemaps\Controller;

use Ig\IgGooglemaps\Domain\Repository\MapsRepository;
use Ig\IgGooglemaps\Domain\Repository\MarkerRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer;

/**
 * MapsController
 */

class MapsController extends ActionController
{
	/**
  * mapsRepository
  *
  * @var MapsRepository
  */
 public $mapsRepository = NULL;

	/**
  * markerRepository
  *
  * @var MarkerRepository
  */
 public $markerRepository = NULL;

    protected ContentObjectRenderer $cObj;

    public function injectMapsRepository(MapsRepository $mapsRepository): void
    {
        $this->mapsRepository = $mapsRepository;
    }

    public function injectMarkerRepository(MarkerRepository $markerRepository): void
    {
        $this->markerRepository = $markerRepository;
    }

    public function injectContentObjectRenderer(ContentObjectRenderer $contentObjectRenderer): void
    {
        $this->cObj = $contentObjectRenderer;
    }

	/**
	 * action list
	 *
	 */
	public function listAction(): ResponseInterface
    {
		// Marker new


		if($this->settings['controls']) {
			$controls = explode(',', (string) $this->settings['controls']);
        } else {
			$controls = [];
        }

		if($this->settings['marker']) {
			$markers = $this->markerRepository->setRespectStoragePage(false)->findByMarkersFromSettings(explode(',', (string) $this->settings['marker']))->toArray();
		} else {
			$markers = [];
		}

		$infowindowOfAllMarkersOpen = boolval($this->settings['infowindowOfAllMarkersOpen'] ?? '');
		$latitude = doubleval($this->settings['latitude'] ?? '');
		$longitude = doubleval($this->settings['longitude'] ?? '');
		$zoom = intval($this->settings['zoom'] ?? '');
		$customStyle = boolval($this->settings['customStyle'] ?? '');
		$customStyleText = $this->settings['customStyleText'] ?? '';
		$style = $this->settings['style'] ?? '';
		$mapType = $this->settings['mapType'] ?? '';
		$googleMapsSubmitClasses = $this->settings['googleMapsSubmitClasses'];
		$customMarkerPath = $this->settings['customMarkerPath'] ?? '';
        $customMarkerWidth = $this->settings['customMarkerWidth'] ?? '';
        $customMarkerHeight = $this->settings['customMarkerHeight'] ?? '';
		$autocalcmapcenter = boolval($this->settings['autocalcmapcenter'] ?? '');
		$aspectRatio = $this->settings['aspectRatio'] ?? '';
		$width = $this->settings['width'] ?? '';
		$height = $this->settings['height'] ?? '';
		$rteActivated = $this->settings['rteActivated'] ?? '';
		$apiUrl = $this->settings['apiUrl'] ?? '';
        $apiKey = $this->settings['apiKey'] ?? '';
		$jsFile = $this->settings['jsFile'] ?? '';

        $currentContentObject = $this->request->getAttribute('currentContentObject');
		// Template vars
        $this->view->assign('identifier', 'map_' . $currentContentObject->data['uid']);
		$this->view->assign('controls', $controls);
		$this->view->assign('markers', $markers);
		$this->view->assign('infowindowOfAllMarkersOpen', $infowindowOfAllMarkersOpen);
		$this->view->assign('latitude', $latitude);
		$this->view->assign('longitude', $longitude);
		$this->view->assign('zoom', $zoom);
		$this->view->assign('mapType', $mapType);
		$this->view->assign('customStyle', $customStyle);
		$this->view->assign('customStyleText', $customStyleText);
		$this->view->assign('style', $style);
		$this->view->assign('googleMapsSubmitClasses', $googleMapsSubmitClasses);
		$this->view->assign('customMarkerPath', $customMarkerPath);
        $this->view->assign('customMarkerWidth', $customMarkerWidth);
        $this->view->assign('customMarkerHeight', $customMarkerHeight);
		$this->view->assign('autocalcmapcenter', $autocalcmapcenter);
		$this->view->assign('aspectRatio', $aspectRatio);
		$this->view->assign('width', $width);
		$this->view->assign('height', $height);
		$this->view->assign('rteActivated', $rteActivated);
		$this->view->assign('apiUrl', $apiUrl);
        $this->view->assign('apiKey', $apiKey);
		$this->view->assign('jsFile', $jsFile);
        return $this->htmlResponse($this->view->render());
	}
}
