/**
 * Module: TYPO3/CMS/IgGooglemaps/MapHandler
 */
define(['jquery', 'jquery/autocomplete'], function ($) {
// var apiUrl = TYPO3.settings.ajaxUrls['tx_iggooglemaps_address_geocode_handler'];
    var MapHandler = {};
    var map;
    var marker;

    /**
     * Initialize the whole thing.
     */
    MapHandler.init = function () {
        $('.ig_googlemaps').each(function () {
            var $mapEl = $(this);

	    // Fill Search Field
	    if( $mapEl.data('searchFields') ) {
		// fill search field with attributes/form fields
		setSearchField=function(obj) {
		    var name= obj===undefined ? 'name' :'data-formengine-input-name';// init call take hidden values, onChange take input fields
		    fields=$mapEl.data('searchFields').split(',');
		    searchValue='';
		    $(fields).each(function( index, val ) {
			el=$(':input['+name+'="data' + $mapEl.data('fieldBase') + '[' + val+ ']"]');
			if( el.val()!== undefined && el.val()!='') {
			    if( searchValue ) {
				searchValue+=' ';
			    }
			    searchValue+=el.val();
			}
		    });
		    $input = $mapEl.find('input.controls');
		    $input.val(searchValue);
		}
		// change search field if a values is changed
		fields=$mapEl.data('searchFields').split(',');
		$(fields).each(function( index, val ) {
		    $(':input[data-formengine-input-name="data' + $mapEl.data('fieldBase') + '[' + val+ ']"]').on('change', setSearchField);
		});
		setSearchField( );

	    }
	    MapHandler.initEmbeddedMap($mapEl);

	    // todo
            $mapEl.find('a.remove-location').click(function (e) {
                e.preventDefault();
                $mapEl.find('details').remove();
            });
        });
    };


    /**
     * Uses an embedded Google Places finder.
     */
    MapHandler.initEmbeddedMap = function ($mapEl) {
        var $formElement = $mapEl;
        var mapContainer = $formElement.find('.map').get(0);
        var input = $formElement.find('input.controls').get(0);
        var apiKey = $formElement.data('api-key');
        var scriptUrlWithKey = 'https://maps.googleapis.com/maps/api/js?libraries=places&key=' + apiKey;
        var $realField = $mapEl.find('input.currentValue');
        //var currentValue = $mapEl.data('current-value');
        require([scriptUrlWithKey], function () {

	    currentPosition=getLatLng($mapEl, $realField);
	    if(currentPosition) {
		//latlngArray=currentPosition.split(',');
		map = new google.maps.Map(mapContainer, {
                    center: currentPosition,
                    zoom: 15
		});
		marker = new google.maps.Marker({
		    position: currentPosition,
		    map: map,
		    draggable: true
		});
	    } else {
		map = new google.maps.Map(mapContainer, {
                    center: {lat:  $mapEl.data('centerLatitude'), lng: $mapEl.data('centerLongitude')},
                    zoom: 13
		});
		marker = new google.maps.Marker({
                    map: map,
		    draggable: true
		});
	    }
                marker.setVisible(true);
		marker.setDraggable(true);
		// Change Fields if marker is dragged
		marker.addListener('dragend', function() {
		    setLatLng($mapEl, $realField, marker.getPosition().lat(), marker.getPosition().lng());
		});

            var autocomplete = new google.maps.places.Autocomplete(input);
            autocomplete.bindTo('bounds', map);

            map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);


            autocomplete.addListener('place_changed', function () {
                //infowindow.close();
                var place = autocomplete.getPlace();
                if (!place.geometry) {
                    return;
                }

                if (place.geometry.viewport) {
                    map.fitBounds(place.geometry.viewport);
                } else {
                    map.setCenter(place.geometry.location);
                    map.setZoom(17);
                }
                marker.setPosition(  place.geometry.location );
                marker.setVisible(true);
		marker.setDraggable(true);
		// Change Fields if marker is dragged
		marker.addListener('dragend', function() {
		    setLatLng($mapEl, $realField, marker.getPosition().lat(), marker.getPosition().lng());
		});

		setLatLng($mapEl, $realField, place.geometry.location.lat(), place.geometry.location.lng());
            });

		$realField.on('change', function() {
		    latLng=getLatLngFromString($(this).val());
		    marker.setPosition( latLng  );
		    map.setCenter(latLng);
		});
		$('input[data-formengine-input-name="data' +  $mapEl.data('fieldBase')+ '[' + $mapEl.data('fieldLatitude') + ']"],input[data-formengine-input-name="data' +  $mapEl.data('fieldBase')+ '[' + $mapEl.data('fieldLongitude') + ']"]').on('change', function() {
		    latLng=getLatLng( $mapEl, $realField);
		    marker.setPosition( latLng  );
		    map.setCenter(latLng);
		});
	});
    };

    getLatLngFromString = function(ll) {
	var latlng = ll.split(/, ?/)
	return new google.maps.LatLng(parseFloat(latlng[0]), parseFloat(latlng[1])); 
    }

    // Get LatLng fields
    getLatLng = function( $mapEl, $realField ) {
	if( $mapEl.data('fieldLatitude') && $mapEl.data('fieldLongitude') ) {
	    lat=getInputField( $mapEl.data('fieldBase'), $mapEl.data('fieldLatitude') );
	    lng=getInputField( $mapEl.data('fieldBase'), $mapEl.data('fieldLongitude') );
	    return {lat:  parseFloat(lat), lng: parseFloat(lng)};
	} else {
	    var currentValue=$realField.val();
	    if( currentValue ) {
		latlngArray=currentValue.split(',');
		return {lat:  parseFloat(latlngArray[0]), lng: parseFloat(latlngArray[1])};
	    }
	}
    }
    // Fill LatLng fields
    setLatLng = function ( $mapEl, $realField, lat, lng) {
        $realField.val(lat + ',' +  lng);
	setInputField( $mapEl.data('fieldBase'), $mapEl.data('fieldLatitude'), lat );
	setInputField( $mapEl.data('fieldBase'), $mapEl.data('fieldLongitude'), lng );
    }
    // Fill a input field with value and check the control[active] if null values are allowed
    setInputField = function( fieldBase, name, value ) {
	if( name ) {
	    fieldBaseName=fieldBase + '[' + name + ']';
	    el=$('input[data-formengine-input-name="data' +  fieldBaseName + '"]');
            el.val(value);
	    el=$('input[name="data' + fieldBaseName + '"]');
            el.val(value);
	    $('input:checkbox[name="control[active]' + fieldBaseName + '"]').not(':checked').click();
	}
    }
    // Fill a input field with value and check the control[active] if null values are allowed
    getInputField = function( fieldBase, name ) {
	fieldBaseName=fieldBase + '[' + name + ']';
	return $('input[name="data' +  fieldBaseName + '"]').val();
	//return $('input[data-formengine-input-name="data' +  fieldBaseName + '"]').val();
    }
    
    MapHandler.init();
});
