<?php
namespace Ig\IgGooglemaps\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
/**
 * Marker
 */
class Marker extends AbstractEntity {

	/**
	 * address
	 *
	 * @var string
	 */
	protected $address = '';

	/**
	 * zip
	 *
	 * @var string
	 */
	protected $zip = '';

	/**
	 * city
	 *
	 * @var string
	 */
	protected $city = '';


	/**
	 * country
	 *
	 * @var string
	 */
	protected $country = '';

	/**
	 * latitude
	 *
	 * @var string
	 */
	protected $latitude = '';

	/**
	 * longitude
	 *
	 * @var string
	 */
	protected $longitude = '';

	/**
	 * geocode
	 *
	 * @var string
	 */
	protected $geocode = '';

	/**
	 * Infotext
	 *
	 * @var string
	 */
	protected $infotext;

    /**
     * locationLink
     *
     * @var string
     */
    protected $locationLink;

	/**
	 * infowindowautoopen
	 *
	 * @var boolean
	 */
	protected $infowindowautoopen = FALSE;

	/**
	 * navigation
	 *
	 * @var boolean
	 */
	protected $navigation = FALSE;

	/**
	 * showInGoogleMaps
	 *
	 * @var boolean
	 */
	protected $showInGooglemaps = FALSE;

	/**
	 * markercolor
	 *
	 * @var string
	 */
	protected $markercolor;

	/**
	 * iconUrl
	 *
	 * @var string
	 */
	protected $iconUrl;

	/**
  * iconFileReference
  *
  * @var FileReference
  * @Cascade("remove")
  */
 protected $iconFileReference = null;

	/**
	 * iconWidth
	 *
	 * @var int
	 */
	protected $iconWidth=0;

	/**
	 * iconHeight
	 *
	 * @var int
	 */
	protected $iconHeight=0;


	/**
	 * Infotext Raw
	 *
	 * @var string
	 */
	protected $infotextRaw='';


	/**
	 * Returns the address
	 *
	 * @return string $address
	 */
	public function getAddress() {
		return $this->address;
	}

	/**
	 * Sets the address
	 *
	 * @param string $address
	 * @return void
	 */
	public function setAddress($address): void {
		$this->address = $address;
	}

	/**
	 * Returns the zip
	 *
	 * @return string $zip
	 */
	public function getZip() {
		return $this->zip;
	}

	/**
	 * Sets the zip
	 *
	 * @param string $zip
	 * @return void
	 */
	public function setZip($zip): void {
		$this->zip = $zip;
	}

	/**
	 * Returns the city
	 *
	 * @return string $city
	 */
	public function getCity() {
		return $this->city;
	}

	/**
	 * Sets the city
	 *
	 * @param string $city
	 * @return void
	 */
	public function setCity($city): void {
		$this->city = $city;
	}

	/**
	 * Returns the country
	 *
	 * @return string $country
	 */
	public function getCountry() {
		return $this->country;
	}

	/**
	 * Sets the country
	 *
	 * @param string $country
	 * @return void
	 */
	public function setCountry($country): void {
		$this->country = $country;
	}

	/**
	 * Returns the latitude
	 *
	 * @return string $latitude
	 */
	public function getLatitude() {
		return $this->latitude;
	}

	/**
	 * Sets the latitude
	 *
	 * @param string $latitude
	 * @return void
	 */
	public function setLatitude($latitude): void {
		$this->latitude = $latitude;
	}

	/**
	 * Returns the longitude
	 *
	 * @return string $longitude
	 */
	public function getLongitude() {
		return $this->longitude;
	}

	/**
	 * Sets the longitude
	 *
	 * @param string $longitude
	 * @return void
	 */
	public function setLongitude($longitude): void {
		$this->longitude = $longitude;
	}

	/**
	 * Returns the geocode
	 *
	 * @return string $geocode
	 */
	public function getGeocode() {
		return $this->geocode;
	}

	/**
	 * Sets the geocode
	 *
	 * @param string $geocode
	 * @return void
	 */
	public function setGeocode($geocode): void {
		$this->geocode = $geocode;
	}

	/**
	 * Returns the infotext
	 *
	 * @return string $infotext
	 */
	public function getInfotext() {
		return $this->infotext;
	}

	/**
	 * Sets the infotext
	 *
	 * @param string $infotext
	 * @return void
	 */
	public function setInfotext($infotext): void {
		$this->infotext = $infotext;
	}



	/**
	 * Returns the infotextRaw
	 *
	 * @return string $infotextRaw
	 */
	public function getInfotextRaw() {
		return $this->infotextRaw;
	}

	/**
	 * Sets the infotextRaw
	 *
	 * @param string $infotextRaw
	 * @return void
	 */
	public function setInfotextRaw($infotextRaw): void {
		$this->infotextRaw = $infotextRaw;
	}



    /**
     * Returns the locationLink
     *
     * @return string $locationLink
     */
    public function getLocationLink() {
        return $this->locationLink;
    }

    /**
     * Sets the locationLink
     *
     * @param string $locationLink
     * @return void
     */
    public function setLocationLink($locationLink): void {
        $this->locationLink = $locationLink;
    }

	/**
	 * Returns the infowindowautoopen
	 *
	 * @return boolean $infowindowautoopen
	 */
	public function getInfowindowautoopen() {
		return $this->infowindowautoopen;
	}

	/**
	 * Sets the infowindowautoopen
	 *
	 * @param boolean $infowindowautoopen
	 * @return void
	 */
	public function setInfowindowautoopen($infowindowautoopen): void {
		$this->infowindowautoopen = $infowindowautoopen;
	}

	/**
	 * Returns the navigation
	 *
	 * @return boolean $navigation
	 */
	public function getNavigation() {
		return $this->navigation;
	}

	/**
	 * Sets the navigation
	 *
	 * @param boolean $navigation
	 * @return void
	 */
	public function setNavigation($navigation): void {
		$this->navigation = $navigation;
	}

	/**
	 * Returns the showInGooglemaps
	 *
	 * @return boolean $showInGooglemaps
	 */
	public function getShowInGooglemaps() {
		return $this->showInGooglemaps;
	}

	/**
	 * Sets the showInGooglemaps
	 *
	 * @param boolean $showInGooglemaps
	 * @return void
	 */
	public function setShowInGooglemaps($showInGooglemaps): void {
		$this->showInGooglemaps = $showInGooglemaps;
	}

	/**
	 * @return \integer $markercolor
	 */
	public function getMarkercolor() {
		return $this->markercolor;
	}

	/**
	 * Sets the markercolor
	 *
	 * @param string $markercolor
	 * @return void
	 */
	public function setMarkercolor($markercolor): void {
		$this->markercolor = $markercolor;
	}

    /**
     * Returns the icon
     *
     * @return string $icon
     */
    public function getIconFile()
    {
        return $this->iconFileReference ? $this->iconFileReference->getOriginalResource()->getPublicUrl() : $this->iconUrl;
    }

    /**
     * Returns the iconFileReference
     *
     * @return FileReference $iconFileReference
     */
    public function getIconFileReference()
    {
        return $this->iconFileReference->getOriginalResource()->getPublicUrl();
    }

    /**
     * Sets the icon
     *
     * @return void
     */
    public function setIconFileReference(FileReference $iconFileReference): void
    {
        $this->iconFileReference = $iconFileReference;
    }

    /**
     * Returns the iconUrl
     *
     * @return string $iconUrl
     */
    public function getIconUrl()
    {
        return $this->iconUrl;
    }

    /**
     * Sets the iconUrl
     *
     * @return void
     */
    public function setIconUrl(string $iconUrl): void
    {
        $this->iconUrl = $iconUrl;
    }

	/**
	 * Returns the iconWidth
	 *
	 * @return int $iconWidth
	 */
	public function getIconWidth():int {
		return $this->iconWidth;
	}

	/**
  * Sets the iconWidth
  *
  * @return void
  */
 public function setIconWidth(int $iconWidth): void {
		$this->iconWidth = $iconWidth;
	}

	/**
	 * Returns the iconHeight
	 *
	 * @return int $iconHeight
	 */
	public function getIconHeight():int {
		return $this->iconHeight;
	}

	/**
  * Sets the iconHeight
  *
  * @return void
  */
 public function setIconHeight(int $iconHeight): void {
		$this->iconHeight = $iconHeight;
	}
}
