<?php
namespace Ig\IgGooglemaps\ViewHelpers;


use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class DirectionsServiceViewHelper extends AbstractViewHelper {

	static public $instanceCount = 0;

	public function initializeArguments(): void
    {
		parent::initializeArguments();
		$this -> registerArgument('destination', 'string', 'destination', FALSE, '');
		$this -> registerArgument('origin', 'string', 'origin', FALSE, '');
		$this -> registerArgument('travelMode', 'string', 'travelMode: DRIVING', FALSE, 'DRIVING');
		$this -> registerArgument('as', 'string', 'Reponse Variable name', FALSE, 'response');
	}

	public function render()
    {
	  $ds = [];
	  $ds['destination']=$this->arguments['destination'];
	  $ds['origin']=$this->arguments['origin'];
	  $ds['travelMode']=$this->arguments['travelMode'];
	  $ds['as']=$this->arguments['as'];
	  $ds['js']=trim((string) $this->renderChildren());
	  $templateVariableContainer = $this->renderingContext->getVariableProvider();
	  $__igGooglemaps=$templateVariableContainer->get('__igGooglemaps');
	  $__igGooglemaps['directionsService'][]=$ds;
	  $templateVariableContainer = $templateVariableContainer->add('__igGooglemaps', $__igGooglemaps);
	  return '';
	  return $content="var directionsService = new google.maps.DirectionsService();
	    directionsDisplay = new google.maps.DirectionsRenderer();
	    directionsDisplay.setMap(map);
	    directionsService.route({
	      origin: ".json_encode($ds['origin']).",
		  destination: ".json_encode($ds['destination']).",
		  travelMode: ".json_encode($ds['travelMode']).",
		  }, function(result, status) {
		console.log('result'+status);
		if (status == 'OK') {
		  directionsDisplay.setDirections(result);
		}
	      });";


	  //	$ds['extraJs'] = trim($this->renderChildren());
	  $this -> addMarker($ds);//
	}

	public function addMarker($marker): void {
		$layers = $this -> templateVariableContainer -> get('layers');
		if (!count($layers)) {
			$layers[] = ['markers' => []];
		}
		$last = array_key_last($layers);
		$layers[$last]['directionsService'][] = $marker;

		$this -> templateVariableContainer -> remove('layers');
		$this -> templateVariableContainer -> add('layers', $layers);
	}

	/**
	 * get the position of the map
	 * first, it checks latlng argument
	 * then, lat and lng arguments
	 *
	 * @return array array('lat'=>latitude, 'lng'=>longitude)
	 */
	protected function getLatLng() {
		$res = [];
		if ($this -> hasArgument('lat') && $this -> hasArgument('lng')) {
			// both argumets set
			$res = ['lat' => floatval($this -> arguments['lat']), 'lng' => floatval($this -> arguments['lng'])];
		} elseif ($this -> hasArgument('latlng')) {
			$lat = NULL;
   $lng = NULL;
   //first priority: commaseparated string or array
			if (is_array($this -> arguments['latlng'])) {
				if (isset($this -> arguments['latlng']['lat'])) {
					$lat = $this -> arguments['latlng']['lat'];
					$lng = $this -> arguments['latlng']['lng'];
				} else {
					$lat = $this -> arguments['latlng'][0];
					$lng = $this -> arguments['latlng'][1];
				}
			} else {
				[$lat, $lng] = GeneralUtility::trimExplode(',', $this -> arguments['latlng'], TRUE);
			}

			$res = ['lat' => floatval($lat), 'lng' => floatval($lng)];
		}

		//validate
		/*
		 * XXX: theoretically, this makes it impossible to set the center to (0,0)
		 * but since there is only sea and we don't have customers from africa, we can simply ignore that.
		 */
		if (!(count($res) == 2 && $res['lat'] && $res['lng'] && $res['lat'] >= -90.0 && $res['lat'] <= 90.0 && $res['lng'] >= -180.0 && $res['lng'] <= 180.0)) {
			return false;
		}

		return $res;
	}

}
