<?php
namespace Ig\IgGooglemaps\ViewHelpers\Render;

use Ig\IgGooglemaps\Domain\Model\Marker;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class MarkerViewHelper extends AbstractTagBasedViewHelper {
	/**
	 * Initialize the arguments.
	 *
	 * @return void
	 * @api
	 */
 	public function initializeArguments(): void {
		parent::initializeArguments();
		
		
		$this->registerArgument('latitude', 'double', 'Latitude of the marker', false, 0);
		$this->registerArgument('longitude', 'double', 'Longitude of the marker', false, 0);
		$this->registerArgument('latlng', 'string', 'latitude,longitude of the map center', false, 0);
        // @todo iconUrl (string) und iconImage/icon (FileReference)
		$this->registerArgument('icon', 'string', 'Custom marker icon full uri', false, '');
		$this->registerArgument('iconWidth', 'int', 'width of icon', false, 0);        
		$this->registerArgument('iconHeight', 'int', 'height of icon', false, 0);
        
        /* deprecated */
		$this->registerArgument('infotext', 'string', 'Infotext', false, '');
		$this->registerArgument('infowindowautoopen', 'bool', 'If the info window should open automatically', false, false);
		$this->registerArgument('navigation', 'bool', 'If a navigation should appear', false, false);
		$this->registerArgument('markercolor', 'string', 'Color of the marker', false, 'red');
		$this->registerArgument('markercustom', 'string', 'Custom marker icon relative path to customMarkerPath', false, '');
		$this->registerArgument('address', 'string', 'Address of the marker', false, '');
		$this->registerArgument('zip', 'string', 'Zip code of the marker', false, '');
		$this->registerArgument('city', 'string', 'City of the marker', false, '');
		$this->registerArgument('country', 'string', 'Country of the marker', false, '');
	}
	
	/**
     * @return void
     */
	public function render(): void {
        $marker = GeneralUtility::makeInstance(Marker::class);

		$marker->setAddress($this->arguments['address']);
		$marker->setZip($this->arguments['zip']);
		$marker->setCity($this->arguments['city']);
		$marker->setCountry($this->arguments['country']);
        if($this->arguments['icon']) {
            $marker->setIconUrl($this->arguments['icon']);
        }

		$marker->setIconWidth($this->arguments['iconWidth']);
		$marker->setIconHeight($this->arguments['iconHeight']);
		if($this->arguments['latlng']) {
			$lat = NULL;
   $lng = NULL;
   //first priority: commaseparated string or array
			if (is_array($this->arguments['latlng'])) {
				if (isset($this->arguments['latlng']['lat'])) {
					$lat = $this->arguments['latlng']['lat'];
					$lng = $this->arguments['latlng']['lng'];
				} else {
					$lat = $this->arguments['latlng'][0];
					$lng = $this->arguments['latlng'][1];
				}
			} else {
				[$lat, $lng] = GeneralUtility::trimExplode(',', $this->arguments['latlng'], TRUE);
			}

			$marker->setLatitude(doubleval($lat));
			$marker->setLongitude(doubleval($lng));

		} else {
            $marker->setLatitude(doubleval($this->arguments['latitude']));
            $marker->setLongitude(doubleval($this->arguments['longitude']));
		}

		$marker->setInfotext($this->arguments['infotext']);
		$html = trim((string) $this->renderChildren());
		$marker->setInfotextRaw($html);

		$marker->setInfowindowautoopen(boolval(intval($this->arguments['infowindowautoopen'])));
		$marker->setNavigation(boolval(intval($this->arguments['navigation'])));
		$marker->setMarkercolor('marker-' . $this->arguments['markercolor']);
        /*
        if($this->arguments['markercustom']) {
            $marker->setMarkercustom($this->arguments['markercustom']);
		}
        */
		if($this->templateVariableContainer->exists('markers')) {
            $markers = $this->templateVariableContainer->get('markers');
            $this->templateVariableContainer->remove('markers');
		} else {
            $markers = [];
		}

		$markers[] = $marker;

		$this->templateVariableContainer->add('markers', $markers);
	}
}

?>		