import $ from 'jquery';

(g=>{var h,a,k,p="The Google Maps JavaScript API",c="google",l="importLibrary",q="__ib__",m=document,b=window;b=b[c]||(b[c]={});var d=b.maps||(b.maps={}),r=new Set,e=new URLSearchParams,u=()=>h||(h=new Promise(async(f,n)=>{await (a=m.createElement("script"));e.set("libraries",[...r]+"");for(k in g)e.set(k.replace(/[A-Z]/g,t=>"_"+t[0].toLowerCase()),g[k]);e.set("callback",c+".maps."+q);a.src=`https://maps.${c}apis.com/maps/api/js?`+e;d[q]=f;a.onerror=()=>h=n(Error(p+" could not load."));a.nonce=m.querySelector("script[nonce]")?.nonce||"";m.head.append(a)}));d[l]?console.warn(p+" only loads once. Ignoring:",g):d[l]=(f,...n)=>r.add(f)&&u().then(()=>d[l](f,...n))})({
	key: document.querySelector('.ig_googlemaps').dataset.apiKey,
	v: "weekly",
	// Use the 'v' parameter to indicate the version to use (weekly, beta, alpha, etc.).
	// Add other bootstrap parameters as needed, using camel case.
});

/**
 * Module: TYPO3/CMS/IgGooglemaps/MapHandler
 */
(function() {
// var apiUrl = TYPO3.settings.ajaxUrls['tx_iggooglemaps_address_geocode_handler'];
    var MapHandler = {};

    /**
     * Initialize the whole thing.
     */
    MapHandler.init = function () {
        $('.ig_googlemaps').each(function () {
            var $mapEl = $(this);
			var $parents = $mapEl.parents('.form-irre-object');
			if( $parents.length==0 ) {
				$parents = $mapEl.parents('form');
			}

			// Fill Search Field
			if( $mapEl.data('searchFields') ) {
				// fill search field with attributes/form fields
				var setSearchField=function(obj) {
					var name= obj===undefined ? 'name' :'data-formengine-input-name';// init call take hidden values, onChange take input fields
					var fields=$mapEl.data('searchFields').split(',');
					var searchValue='';
					$(fields).each(function( index, val ) {
						var el=$parents.find(':input['+name+'="data' + $mapEl.data('fieldBase') + '[' + val+ ']"]');
						if( el.val()!== undefined && el.val()!='') {
							if( searchValue ) {
								searchValue+=' ';
							}
							searchValue+=el.val();
						}
					});
					var $input = $mapEl.find('input.controls');
					$input.val(searchValue);
				}
				// change search field if a values is changed
				var fields=$mapEl.data('searchFields').split(',');
				$(fields).each(function( index, val ) {
					$parents.find(':input[data-formengine-input-name="data' + $mapEl.data('fieldBase') + '[' + val+ ']"]').on('change', setSearchField);
				});
				setSearchField( );
			}
			MapHandler.initEmbeddedMap($mapEl);

			// todo
            $mapEl.find('a.remove-location').click(function (e) {
                e.preventDefault();
                $mapEl.find('details').remove();
            });
        });
    };


    /**
     * Uses an embedded Google Places finder.
     */
    MapHandler.initEmbeddedMap = async function ($mapEl) {
		var map;
		var marker;
        var $formElement = $mapEl;
        var mapContainer = $formElement.find('.map').get(0);
        var input = $formElement.find('input.controls').get(0);
        var $realField = $mapEl.find('input.currentValue');
        //var currentValue = $mapEl.data('current-value');

		var currentPosition=getLatLng($mapEl, $realField);
		if(currentPosition) {
			//latlngArray=currentPosition.split(',');
			const { Map } = await google.maps.importLibrary("maps");
			map = new Map(mapContainer, {
				center: currentPosition,
				zoom: 15
			});
			const { Marker } = await google.maps.importLibrary("marker");
			marker = new Marker({
				position: currentPosition,
				map: map,
				draggable: true
			});
		} else {
			map = new Map(mapContainer, {
				center: {lat:  $mapEl.data('centerLatitude'), lng: $mapEl.data('centerLongitude')},
				zoom: 13
			});
			marker = new Marker({
				map: map,
				draggable: true
			});
		}

		marker.setVisible(true);
		marker.setDraggable(true);
		// Change Fields if marker is dragged
		marker.addListener('dragend', function() {
			setLatLng($mapEl, $realField, marker.getPosition().lat(), marker.getPosition().lng());
		});

		const places = await google.maps.importLibrary("places");
		var autocomplete = new places.Autocomplete(input);
		autocomplete.bindTo('bounds', map);

		map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);


		autocomplete.addListener('place_changed', function () {
		//infowindow.close();
		var place = autocomplete.getPlace();
		if (!place.geometry) {
			return;
		}

		if (place.geometry.viewport) {
			map.fitBounds(place.geometry.viewport);
		} else {
			map.setCenter(place.geometry.location);
			map.setZoom(17);
		}
		marker.setPosition(  place.geometry.location );
		marker.setVisible(true);
		marker.setDraggable(true);
		// Change Fields if marker is dragged
		marker.addListener('dragend', function() {
			setLatLng($mapEl, $realField, marker.getPosition().lat(), marker.getPosition().lng());
		});

		setLatLng($mapEl, $realField, place.geometry.location.lat(), place.geometry.location.lng());
			});

		$realField.on('change', function() {
			latLng=getLatLngFromString($(this).val());
			marker.setPosition( latLng  );
			map.setCenter(latLng);
		});
		var $parents = $mapEl.parents('.form-irre-object');
		if( $parents.length==0 ) {
			$parents = $mapEl.parents('form');
		}
		$parents.find('input[data-formengine-input-name="data' +  $mapEl.data('fieldBase')+ '[' + $mapEl.data('fieldLatitude') + ']"],input[data-formengine-input-name="data' +  $mapEl.data('fieldBase')+ '[' + $mapEl.data('fieldLongitude') + ']"]').on('change', function() {
			latLng=getLatLng( $mapEl, $realField);
			marker.setPosition( latLng  );
			map.setCenter(latLng);
		});
    };

    var getLatLngFromString = function(ll) {
		var latlng = ll.split(/, ?/)
		return new google.maps.LatLng(parseFloat(latlng[0]), parseFloat(latlng[1])); 
    }

    // Get LatLng fields
    var getLatLng = function( $mapEl, $realField ) {
		if( $mapEl.data('fieldLatitude') && $mapEl.data('fieldLongitude') ) {
			var lat=getInputField($mapEl, $mapEl.data('fieldBase'), $mapEl.data('fieldLatitude') );
			var lng=getInputField($mapEl, $mapEl.data('fieldBase'), $mapEl.data('fieldLongitude') );
			return {lat:  parseFloat(lat), lng: parseFloat(lng)};
		} else {
			var currentValue=$realField.val();
			if( currentValue ) {
				var latlngArray=currentValue.split(',');
				return {lat:  parseFloat(latlngArray[0]), lng: parseFloat(latlngArray[1])};
			}
		}
    }
    // Fill LatLng fields
    var setLatLng = function ( $mapEl, $realField, lat, lng) {
        $realField.val(lat + ',' +  lng);
		setInputField($mapEl, $mapEl.data('fieldBase'), $mapEl.data('fieldLatitude'), lat );
		setInputField($mapEl, $mapEl.data('fieldBase'), $mapEl.data('fieldLongitude'), lng );
    }
    // Fill a input field with value and check the control[active] if null values are allowed
    var setInputField = function($mapEl, fieldBase, name, value ) {
		if( name ) {
			var $parents = $mapEl.parents('.form-irre-object');
			if( $parents.length==0 ) {
				$parents = $mapEl.parents('form');
			}
			var fieldBaseName=fieldBase + '[' + name + ']';
			var el=$parents.find('input[data-formengine-input-name="data' +  fieldBaseName + '"]');
				el.val(value);
			el=$parents.find('input[name="data' + fieldBaseName + '"]');
				el.val(value);
			$parents.find('input:checkbox[name="control[active]' + fieldBaseName + '"]').not(':checked').click();
		}
    }
    // Fill a input field with value and check the control[active] if null values are allowed
    var getInputField = function($mapEl, fieldBase, name ) {
		var fieldBaseName=fieldBase + '[' + name + ']';
		var $parents = $mapEl.parents('.form-irre-object');
		if( $parents.length==0 ) {
			$parents = $mapEl.parents('form');
		}
		return $parents.find('input[name="data' +  fieldBaseName + '"]').val();
		//return $('input[data-formengine-input-name="data' +  fieldBaseName + '"]').val();
    }
    
    MapHandler.init();
})();