<?php

namespace Ig\IgGooglemaps\Form\Element;

use TYPO3\CMS\Core\Configuration\ExtensionConfiguration;
use TYPO3\CMS\Backend\Form\Element\InputTextElement;
use TYPO3\CMS\Core\Information\Typo3Version;
use TYPO3\CMS\Core\Page\JavaScriptModuleInstruction;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\MathUtility;
use TYPO3\CMS\Fluid\View\StandaloneView;

class MapElement extends InputTextElement
{
    /**
     * @var StandaloneView
     */
    protected $view;

    public function __construct()
    {
        $this->view = $this->prepareView();
    }

    /**
     * Handler for single nodes
     *
     * @return array As defined in initializeResultArray() of AbstractNode
     */
    public function render(): array
    {
        $parameterArray = $this->data['parameterArray'];
        $resultArray = $this->initializeResultArray();

        $config = $parameterArray['fieldConf']['config'];
        $size = MathUtility::forceIntegerInRange(
            $config['size'] ?? $this->defaultInputWidth,
            $this->minimumInputWidth,
            $this->maxInputWidth
        );
        // Add a wrapper to remain maximum width
        $width = (int) $this->formMaxWidth($size);

        //$currentValue = json_decode($parameterArray['itemFormElValue']) ?: [];
        $currentValue = $parameterArray['itemFormElValue'] ? : '';//) ?: [];
        
        $extConf = GeneralUtility::makeInstance(
            ExtensionConfiguration::class
        )->get('ig_googlemaps');

        //var_dump($this->data['elementBaseName']);
        //var_dump($parameterArray['itemFormElName']);exit(0);
        $itemFormElName=$this->data['elementBaseName'];//$parameterArray['itemFormElName'];
        $fieldBase=substr((string) $itemFormElName,0,strrpos((string) $itemFormElName,'['));
        $searchFields=GeneralUtility::trimExplode(',',$parameterArray['fieldConf']['config']['searchFields']);
        $this->view->assignMultiple(
            [
                'apiKey'           => $extConf['googleMapsGeocodingApiKey'],
                'currentValue'     => $currentValue ?: '',
                'currentValueJson' => json_encode($currentValue),
                'parameterArray'   => $parameterArray,
                'searchFields'   => implode(',',$searchFields),
                'centerLatitude'   => $parameterArray['fieldConf']['config']['centerLatitude'] ?? '46.7571319',
                'centerLongitude'   => $parameterArray['fieldConf']['config']['centerLongitude'] ?? '7.627482699999973',
                'fieldName'         => $this->data['fieldName'],
                'fieldBase'         => $fieldBase,
                'width'            => $width,
            ]
        );

        $resultArray['html'] = $this->view->render();

        $typo3Version = GeneralUtility::makeInstance(Typo3Version::class);

        if($typo3Version->getMajorVersion() > 11) {
            $resultArray['javaScriptModules'][] = JavaScriptModuleInstruction::create(
                '@internetgalerie/ig-googlemaps/map-element.js'
            );
        } else {
            $resultArray['requireJsModules'] = ['TYPO3/CMS/IgGooglemaps/MapHandler'];
        }

        //DebuggerUtility::var_dump($resultArray);

        return $resultArray;
    }



    /**
     * @return StandaloneView
     */
    protected function prepareView()
    {
        $view = new StandaloneView();
        $view->setTemplateRootPaths(
            [10 => GeneralUtility::getFileAbsFileName('EXT:ig_googlemaps/Resources/Private/Backend/Templates/')]
        );
        $view->setTemplate('MapElement.html');

        return $view;
    }
}
