<?php

namespace Ig\IgGooglemaps\Controller;

//deprecated
use TYPO3\CMS\Core\Configuration\ExtensionConfiguration;
use TYPO3\CMS\Core\Http\AjaxRequestHandler;
use TYPO3\CMS\Core\Http\RequestFactory;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Http\JsonResponse;

class GeocodingController
{
    public const API_URL = 'https://maps.googleapis.com/maps/api/geocode/json?';

    /**
     * @param $ajaxParameters
     * @param AjaxRequestHandler $ajaxRequestHandler
     */
    public function geocode(ServerRequestInterface $request): ResponseInterface
    {

        $address = $request->getQueryParams()['query'];
        $queryData = http_build_query(
            [
                'v'     => '3',
                'key'     => $this->getApiKey(),
                'address' => $address,
            ]
        );

        $report = [];
        $url = static::API_URL . $queryData;
        //$result = GeneralUtility::getUrl($url, 0, false, $report);
        $result = GeneralUtility::makeInstance(RequestFactory::class)->request($url, 'GET', ['headers' => ['accept' => 'application/json']]);
        $response = new JsonResponse(['data' => $result]);
        return $response;
    }

    /**
     * Retreives the API key from the extension configuration.
     *
     * @return string
     */
    protected function getApiKey()
    {
        $extConf = GeneralUtility::makeInstance(
            ExtensionConfiguration::class
        )->get('ig_googlemaps');
        return $extConf['googleServerGeocodingApiKey'];
    }
}
