<?php
return  [
    'ctrl' => [
        'title'    => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker',
        'label' => 'address',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        // 'cruser_id' => 'cruser_id',
        'dividers2tabs' => true,
        'hideTable' => true,

        'versioningWS' => 2,
        'versioning_followPages' => true,

        /*'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',*/
        'sortby' => 'sorting',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'security' => [
            'ignorePageTypeRestriction' => true,
        ],
        'searchFields' => 'address,',
        'iconfile' => 'EXT:ig_googlemaps/Resources/Public/Icons/tx_iggooglemaps_domain_model_marker.png',
    ],
    'interface' => [],
    'types' => [
        '1' => [
            'showitem' => 'l10n_parent, l10n_diffsource,
			--palette--;LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.paletteAddress;paletteAddress,

			geocode;;,latitude,longitude,

            --div--;LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.tabInfowindow,
            infoText;LLL:EXT:cms/locallang_ttc.xlf:rte_enabled_formlabel,
            location_link, infowindowautoopen, navigation, show_in_googlemaps,

			--div--;LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.tabOptions,
				--palette--;LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.paletteCore;paletteCore,
				--palette--;LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.paletteMarker;paletteMarker,
			'
        ]
    ],
    'palettes' => [
        'paletteCore' => [
            'showitem' => 'hidden, sys_language_uid',
            'canNotCollapse' => true
        ],
        'paletteAddress' => [
            'showitem' => 'address, --linebreak--, zip, city, --linebreak--, country',
            'canNotCollapse' => true
        ],
        'paletteLatLng' => [
            'showitem' => 'latitude, longitude',
            'canNotCollapse' => true
        ],
        'paletteMarker' => [
            'showitem' => 'markercolor, --linebreak--, icon_file_reference,  --linebreak--, icon_url',
            'canNotCollapse' => true
        ]
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'language',
            ],
            /*
			'config' => [
				'type' => 'select',
				'renderType' => 'selectSingle',
				'foreign_table' => 'sys_language',
				'foreign_table_where' => 'ORDER BY sys_language.title',
				'items' => [
					[
						'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.allLanguages',
						-1
					],
					[
						'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.default_value',
						0
					]
				]
			]
*/
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    [
                        'label' => '',
                        'value' => 0
                    ]
                ],
                'foreign_table' => 'tx_iggooglemaps_domain_model_marker',
                'foreign_table_where' => 'AND tx_iggooglemaps_domain_model_marker.pid=###CURRENT_PID### AND tx_iggooglemaps_domain_model_marker.sys_language_uid IN (-1,0)'
            ]
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough'
            ]
        ],

        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255
            ]
        ],

        'hidden' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.hidden',
            'config' => [
                'type' => 'check'
            ]
        ],
        'starttime' => [
            'exclude' => 1,
            'l10n_mode' => 'mergeIfNotBlank',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'input',
                'size' => 13,
                'max' => 20,
                'eval' => 'datetime',
                'checkbox' => 0,
                'default' => 0,
                'range' => [
                    'lower' => mktime(0, 0, 0, date('m'), date('d'), date('Y'))
                ]
            ]
        ],
        'endtime' => [
            'exclude' => 1,
            'l10n_mode' => 'mergeIfNotBlank',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'input',
                'size' => 13,
                'max' => 20,
                'eval' => 'datetime',
                'checkbox' => 0,
                'default' => 0,
                'range' => [
                    'lower' => mktime(0, 0, 0, date('m'), date('d'), date('Y'))
                ]
            ]
        ],

        'address' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.address',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
                'required' => true,
            ]
        ],

        'zip' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.zip',
            'config' => [
                'type' => 'input',
                'size' => 5,
                'eval' => 'trim',
                'required' => true,
            ]
        ],

        'city' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.city',
            'config' => [
                'type' => 'input',
                'size' => 19,
                'eval' => 'trim',
                'required' => true,
            ]
        ],

        'country' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.country',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
                'required' => true,
            ]
        ],
        'geocode' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ferienpass/Resources/Private/Language/locallang_db.xlf:tx_igferienpass_domain_model_kurs.ku_googlemaps',
            'config' => [
                'type' => 'user',
                'renderType' => 'geocodeSectionIrre',
                'searchFields' => 'address,zip,city',
                'fieldLatitude' => 'latitude',
                'fieldLongitude' => 'longitude',
                'centerLatitude' => '46.7571319',
                'centerLongitude' => '7.627482699999973',
                'cols'       => 40,
                'rows'       => 15,
                'eval'       => 'trim',
                'size'       => 50,
                'default'    => '',
            ],
        ],
        'latitude' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.latitude',
            'config' => [
                'type' => 'input',
                'size' => 8,
                'eval' => 'trim'
            ]
        ],
        'longitude' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.longitude',
            'config' => [
                'type' => 'input',
                'size' => 8,
                'eval' => 'trim'
            ]
        ],
        'infoText' => [
            'exclude' => 0,
            //'l10n_mode' => 'prefixLangTitle',
            'l10n_mode' => 'noCopy',
            'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.infoText',
            'config' => [
                'type' => 'text',
                'cols' => 30,
                'rows' => 5,
                'enableRichtext' => true,
            ],
        ],
        'location_link' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.locationLink',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ]
        ],
        'infowindowautoopen' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.infowindowautoopen',
            'config' => [
                'type' => 'check'
            ]
        ],

        'navigation' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.navigation',
            'config' => [
                'type' => 'check'
            ]
        ],

        'show_in_googlemaps' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.show_in_googlemaps',
            'config' => [
                'type' => 'check'
            ]
        ],

        'markercolor' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.markercolor',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    [
                        'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.markercolor.1',
                        'value' => 'marker-red'
                    ],
                    [
                        'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.markercolor.2',
                        'value' => 'marker-green'
                    ],
                    [
                        'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.markercolor.3',
                        'value' => 'marker-blue'
                    ],
                    [
                        'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.markercolor.4',
                        'value' => 'marker-yellow'
                    ],
                    [
                        'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.markercolor.5',
                        'value' => 'marker-orange'
                    ],
                    [
                        'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.markercolor.6',
                        'value' => 'marker-black'
                    ],
                    [
                        'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.markercolor.7',
                        'value' => 'marker-white'
                    ]
                ],
                'size' => 1,
                'maxitems' => 1,
                'eval' => ''
            ]
        ],
        'icon_url' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.icon_url',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ]
        ],


        'icon_file_reference' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang_db.xlf:tx_iggooglemaps_domain_model_marker.icon_file_reference',
            'config' => [
                'type' => 'file',
                'foreign_match_fields' => [
                    'tablenames' => 'tx_iggooglemaps_domain_model_marker',
                ],
                'maxitems' => 1,
                'allowed' => 'common-image-types',
            ],
        ]
    ]
];
