<?php

namespace Ig\IgGooglemaps\Domain\Model;


use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Fluid\View\StandaloneView;
use Internetgalerie\IgCookies\Utility\ConfigUtility;
use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Core\Utility\PathUtility;
use TYPO3\CMS\Extbase\Mvc\ExtbaseRequestParameters;
use TYPO3\CMS\Extbase\Mvc\Request;
use TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer;
use \TYPO3\CMS\Core\Utility\GeneralUtility;

class Maps extends AbstractEntity
{
    /**
     * Instance count, helps uniquely identifying the map-object
     *
     * @var int
     */
    public static $instanceCount = 0;

    /**
     * Boolean for checking if the javascript is already included to avoid a double-include if multiple maps are on one page
     *
     * @var bool
     */
    public static $jsIncluded = false;

    /**
     * @var string
     */
    protected $identifier;

    /**
     * @var array
     */
    protected $controls;

    /**
     * @var ObjectStorage<\Med\IgGooglemaps\Domain\Model\Marker>
     */
    protected $markers;

    /**
     * @var array
     */
    protected $directionsService;

    /**
     * @var bool
     */
    protected $infowindowOfAllMarkersOpen;

    /**
     * @var double
     */
    protected $latitude;

    /**
     * @var double
     */
    protected $longitude;

    /**
     * @var int
     */
    protected $zoom;

    /**
     * @var string
     */
    protected $customStyle;

    /**
     * @var string
     */
    protected $customStyleText;

    /**
     * @var string
     */
    protected $style;

    /**
     * @var string
     */
    protected $mapType;

    /**
     * @var string
     */
    protected $googleMapsSubmitClasses;

    /**
     * @var string
     */
    protected $customMarkerPath;

    /**
     * @var string
     */
    protected $customMarkerWidth;

    /**
     * @var string
     */
    protected $customMarkerHeight;

    /**
     * @var bool
     */
    protected $autocalcmapcenter;

    /**
     * @var string
     */
    protected $aspectRatio;

    /**
     * @var string
     */
    protected $width;

    /**
     * @var string
     */
    protected $height;

    /**
     * @var bool
     */
    protected $rteActivated;

    /**
     * @var string
     */
    protected $apiUrl;

    /**
     * @var string
     */
    protected $apiKey;

    /**
     * @var string
     */
    protected $jsFile;

    /**
     * @var array
     */
    protected $infoTextArray;

    protected bool $useConsentManager = false;
    protected bool $markerclustererplus = false;
    protected int $markerClusterMaxZoom = 0;
    protected bool $zoomChangeBoundsListener = true;

    /**
     * Constructor, increments $instanceCount
     */
    public function __construct()
    {
        ++self::$instanceCount;
        if (class_exists(ConfigUtility::class) && ConfigUtility::isActive()) {
            $this->useConsentManager = true;
        }
    }

    /**
     * @return string
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /**
     * @return array
     */
    public function getControls()
    {
        return $this->controls;
    }

    /**
     * @return ObjectStorage<\Med\IgGooglemaps\Domain\Model\Marker>
     */
    public function getMarkers()
    {
        return $this->markers;
    }

    /**
     * @return bool
     */
    public function getMarkerclustererplus()
    {
        return $this->markerclustererplus;
    }

    /**
     * @return bool
     */
    public function getInfowindowOfAllMarkersOpen()
    {
        return $this->infowindowOfAllMarkersOpen;
    }

    /**
     * @return double
     */
    public function getLatitude()
    {
        return $this->latitude;
    }

    /**
     * @return double
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * @return int
     */
    public function getZoom()
    {
        return $this->zoom;
    }

    /**
     * @return string
     */
    public function getCustomStyle()
    {
        return $this->customStyle;
    }

    /**
     * @return string
     */
    public function getCustomStyleText()
    {
        return $this->customStyleText;
    }

    /**
     * @return string
     */
    public function getStyle()
    {
        return $this->style;
    }

    /**
     * @return string
     */
    public function getMapType()
    {
        return $this->mapType;
    }

    /**
     * @return string
     */
    public function getGoogleMapsSubmitClasses()
    {
        return $this->googleMapsSubmitClasses;
    }

    /**
     * @return string
     */
    public function getCustomMarkerPath()
    {
        return $this->customMarkerPath;
    }

    /**
     * @return string
     */
    public function getCustomMarkerWidth()
    {
        return $this->customMarkerWidth;
    }

    /**
     * @return string
     */
    public function getCustomMarkerHeight()
    {
        return $this->customMarkerHeight;
    }

    /**
     * @return bool
     */
    public function getAutocalcmapcenter()
    {
        return $this->autocalcmapcenter;
    }

    /**
     * @return string
     */
    public function getAspectRatio()
    {
        return $this->aspectRatio;
    }

    /**
     * @return string
     */
    public function getWidth()
    {
        return $this->width;
    }

    /**
     * @return string
     */
    public function getHeight()
    {
        return $this->height;
    }

    /**
     * @return bool
     */
    public function getRteActivated()
    {
        return $this->rteActivated;
    }

    /**
     * @return string
     */
    public function getApiUrl()
    {
        return $this->apiUrl;
    }

    /**
     * @return string
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }

    /**
     * @return string
     */
    public function getJsFile()
    {
        return $this->jsFile;
    }

    /**
     * Sets the identifier
     *
     * @param array $identifier
     *
     * @return void
     */
    public function setIdentifier($identifier): void
    {
        $this->identifier = $identifier;
    }

    /**
     * Sets the controls
     *
     * @param array $controls
     *
     * @return void
     */
    public function setControls($controls): void
    {
        $this->controls = $controls;
    }

    /**
     * Sets the markers
     *
     * @param ObjectStorage<\Med\IgGooglemaps\Domain\Model\Marker> $markers
     *
     * @return void
     */
    public function setMarkers($markers): void
    {
        $this->markers = $markers;
    }

    public function renderMarkers($mapVariableName)
    {
        if (!$this->markers)
            return '';

        $i = 1;
        $locationsArray = [];
        $infoTextArray = [];
        foreach ($this->markers as $marker) {
            // Clear vars
            $navigationOutput = '';
            $locationLinkOutput = '';
            $showInGoogleMapsOutput = '';

            $infoTextOutput = $marker->getInfotextRaw(); // Text von RenderChild des markers
            if ($marker->getInfotext()) {
                $infoTextOutput = $this->getInfotextOutput($marker);

                if ($marker->getNavigation()) {
                    $navigationOutput = "\n" . $this->getNavigationOutput($marker);
                } else {
                    $navigationOutput = '';
                }

                if ($marker->getLocationLink()) {
                    $locationLinkOutput = "\n" . $this->getLocationLinkOutput($marker);
                } else {
                    $locationLinkOutput = '';
                }

                if ($marker->getShowInGooglemaps()) {
                    $showInGoogleMapsOutput = "\n" . $this->getShowInGooglemapsOutput($marker);
                } else {
                    $showInGoogleMapsOutput = '';
                }
            }

            $infoTextContent = $infoTextOutput . $navigationOutput . $locationLinkOutput . $showInGoogleMapsOutput;

            // Locations
            if ($marker->getInfowindowautoopen())
                $infoWindowAutoOpen = $marker->getInfowindowautoopen();
            else {
                $infoWindowAutoOpen = 0;
            }
            if ($marker->getIconFile()) {
                $iconWidth = $marker->getIconWidth() ?: $this->customMarkerWidth;
                $iconHeight = $marker->getIconHeight() ?: $this->customMarkerHeight;
                $markerCustomIcon = $marker->getIconFile();
                if ($iconWidth && $iconHeight) {
                    $markerCustomIconJavaScript = 'new google.maps.MarkerImage("' . $markerCustomIcon . '", null, null, null, new google.maps.Size(' . $iconWidth . ',' . $iconHeight . '))';
                } else {
                    $markerCustomIconJavaScript = '"' . $markerCustomIcon . '"';
                }
            } else {
                $markerCustomIcon = '';
                $markerCustomIconJavaScript = '""';
            }

            $infoTextArray[] = '<div class="marker-id-' . ($i - 1) . ' ">' . $infoTextContent . '</div>';
            //		 			' . json_encode($infoTextContent) . ',
            $locationsArray[] = '[
		 			".marker-id-' . ($i - 1) . '",
					' . $marker->getLatitude() . ',
					' . $marker->getLongitude() . ',
					' . $infoWindowAutoOpen . ',
					"' . $marker->getMarkercolor() . '",
					' . $markerCustomIconJavaScript . '
				]';

            ++$i;
        }


        $locationsOutput = 'var locations = [' . implode(',', $locationsArray) . '];';
        $processMarker = 'var i;
            let markerContainer = mapElement.parentElement.getElementsByClassName("map-marker-infotext-container")[0];
			for (i = 0; i < locations.length; i++) {
                 if(locations[i][4]) {
                    var markerIcon = "' . PathUtility::getPublicResourceWebPath('EXT:ig_googlemaps/Resources/Public/Icons/marker2/') . '" + locations[i][4] + ".png";
                } else {
                    var markerIcon = "";
                }

                if(locations[i][5]) {
                    var markerIcon = locations[i][5];
                }

                marker[i] = new google.maps.Marker({
                    position: new google.maps.LatLng(locations[i][1], locations[i][2]),
                    map: map,
                    icon: markerIcon
                });
                ' .
            ($this->autocalcmapcenter ? 'bounds.extend(marker[i].position);' : ''
            )
            . '
                if(locations[i][0]) {
                    let markerElement = markerContainer.querySelector(locations[i][0]);
                    marker[i].medInfoWindow = new google.maps.InfoWindow({
                        content: markerElement.innerHTML,
                        disableAutoPan: true
                    });

                    google.maps.event.addListener(marker[i], "click", function() {
                        /* Close previously opened infowindows */
                        for (i = 0; i < locations.length; i++) {
                        	if(marker[i].medInfoWindow)
                            	marker[i].medInfoWindow.close();
                        }

                        this.medInfoWindow.disableAutoPan = false;
                        this.medInfoWindow.open(map,this);
                    });

                    if(locations[i][3] == 1) {
                        autoOpen.push(i);
                    }
                }
            }';

        if ($this->markerclustererplus) {
            // Add a marker clusterer to manage the markers.
            $absolutePath = PathUtility::getPublicResourceWebPath('EXT:ig_googlemaps/Resources/Public/UtilityLibrary/markerclustererplus/images/');
            $markerClustererOptions = "imagePath: '" . $absolutePath . "m'";
            if ($this->markerClusterMaxZoom) {
                $markerClustererOptions .= ', maxZoom: ' . $this->markerClusterMaxZoom;
            }
            $processMarker .= " var markerCluster = new MarkerClusterer(map, marker, {" . $markerClustererOptions . "});
";
        }

        $this->infoTextArray = $infoTextArray;
        return  $locationsOutput . $processMarker;
    }

    /**
     * Sets the directionsService
     *
     * @param array $directionsService
     *
     * @todo directionsService muesste ein Model sein
     *
     * @return void
     */
    public function setDirectionsService($directionsService): void
    {
        $this->directionsService = $directionsService;
    }

    /**
     * @return array
     */
    public function getDirectionsService()
    {
        return $this->directionsService;
    }

    /**
     * @return string the javascript for the directionsService
     */
    public function renderDirectionsService($mapVariableName)
    {
        $content = '';
        foreach ($this->directionsService as $ds) {
            $content .= "var directionsService = new google.maps.DirectionsService();
	    directionsDisplay = new google.maps.DirectionsRenderer();
	    directionsDisplay.setMap(" . $mapVariableName . ");
	    directionsService.route({
	      origin: " . json_encode($ds['origin']) . ",
		  destination: " . json_encode($ds['destination']) . ",
		  travelMode: " . json_encode($ds['travelMode']) . ",
		  }, function(" . $ds['as'] . ", status) {
		if (status == 'OK') {
		  " . ($ds['js'] ?: "directionsDisplay.setDirections(" . $ds['as'] . ");") . "
		}
	      });\n";
        }

        return $content;
    }



    /**
     * Sets the markerclustererplus
     *
     * @param bool $markerclustererplus
     *
     * @return void
     */
    public function setMarkerclustererplus($markerclustererplus): void
    {
        $this->markerclustererplus = $markerclustererplus;
    }


    public function getMarkerClusterMaxZoom()
    {
        return $this->markerClusterMaxZoom;
    }
    public function setMarkerClusterMaxZoom(int $markerClusterMaxZoom): void
    {
        $this->markerClusterMaxZoom = $markerClusterMaxZoom;
    }

    /**
     * Sets the autocalcmapcenter
     *
     * @param bool $autocalcmapcenter
     *
     * @return void
     */
    public function setInfowindowOfAllMarkersOpen($infowindowOfAllMarkersOpen): void
    {
        $this->infowindowOfAllMarkersOpen = $infowindowOfAllMarkersOpen;
    }

    /**
     * Sets the latitude
     *
     * @param double $latitude
     *
     * @return void
     */
    public function setLatitude($latitude): void
    {
        $this->latitude = $latitude;
    }

    /**
     * Sets the longitude
     *
     * @param double $longitude
     *
     * @return void
     */
    public function setLongitude($longitude): void
    {
        $this->longitude = $longitude;
    }

    /**
     * Sets the zoom
     *
     * @param int $zoom
     *
     * @return void
     */
    public function setZoom($zoom): void
    {
        $this->zoom = $zoom;
    }

    /**
     * Sets the customStyle
     *
     * @param string $customStyle
     *
     * @return void
     */
    public function setCustomStyle($customStyle): void
    {
        $this->customStyle = $customStyle;
    }

    /**
     * Sets the customStyleText
     *
     * @param string $customStyleText
     *
     * @return void
     */
    public function setCustomStyleText($customStyleText): void
    {
        $this->customStyleText = $customStyleText;
    }

    /**
     * Sets the style
     *
     * @param string $style
     *
     * @return void
     */
    public function setStyle($style): void
    {
        $this->style = $style;
    }

    /**
     * Sets the mapType
     *
     * @param string $mapType
     *
     * @return void
     */
    public function setMapType($mapType): void
    {
        $this->mapType = $mapType;
    }

    /**
     * Sets the googleMapsSubmitClasses
     *
     * @param string $googleMapsSubmitClasses
     *
     * @return void
     */
    public function setGoogleMapsSubmitClasses($googleMapsSubmitClasses): void
    {
        $this->googleMapsSubmitClasses = $googleMapsSubmitClasses;
    }

    /**
     * Sets the customMarkerPath
     *
     * @param string $customMarkerPath
     *
     * @return void
     */
    public function setCustomMarkerPath($customMarkerPath): void
    {
        $this->customMarkerPath = $customMarkerPath;
    }

    /**
     * Sets the customMarkerWidth
     *
     * @param string $customMarkerWidth
     *
     * @return void
     */
    public function setCustomMarkerWidth($customMarkerWidth): void
    {
        $this->customMarkerWidth = $customMarkerWidth;
    }

    /**
     * Sets the customMarkerHeight
     *
     * @param string $customMarkerHeight
     *
     * @return void
     */
    public function setCustomMarkerHeight($customMarkerHeight): void
    {
        $this->customMarkerHeight = $customMarkerHeight;
    }

    /**
     * Sets the autocalcmapcenter
     *
     * @param bool $autocalcmapcenter
     *
     * @return void
     */
    public function setAutocalcmapcenter($autocalcmapcenter): void
    {
        $this->autocalcmapcenter = $autocalcmapcenter;
    }

    /**
     * Sets the aspectratio
     *
     * @param bool $aspectratio
     *
     * @return void
     */
    public function setAspectRatio($aspectRatio): void
    {
        $this->aspectRatio = $aspectRatio;
    }

    /**
     * Sets the width
     *
     * @param string $width
     *
     * @return void
     */
    public function setWidth($width): void
    {
        $this->width = $width;
    }

    /**
     * Sets the height
     *
     * @param string $height
     *
     * @return void
     */
    public function setHeight($height): void
    {
        $this->height = $height;
    }

    /**
     * Sets the rteActivated
     *
     * @param bool $rteActivated
     *
     * @return void
     */
    public function setRteActivated($rteActivated): void
    {
        $this->rteActivated = $rteActivated;
    }

    /**
     * Sets the apiUrl
     *
     * @param string $apiUrl
     *
     * @return void
     */
    public function setApiUrl($apiUrl): void
    {
        $this->apiUrl = $apiUrl;
    }

    /**
     * Sets the apiKey
     *
     * @param string $apiKey
     *
     * @return void
     */
    public function setApiKey($apiKey): void
    {
        $this->apiKey = $apiKey;
    }

    /**
     * Sets the jsFile
     *
     * @param string $jsFile
     *
     * @return void
     */
    public function setJsFile($jsFile): void
    {
        $this->jsFile = $jsFile;
    }

    /**
     * get markers in hidden div 
     * @todo must be call after generateJavaScript (should be generated if null)
     */
    public function getInfotextContent()
    {
        if ($this->infoTextArray === null) {
            return '';
        }

        $content = implode("\n", $this->infoTextArray);
        return '<div class="map-marker-infotext-container" style="visibility:hidden;height:0;width:0;overflow:hidden;">' . $content . '</div>';
    }

    /**
     * get and generate js for map
     * @todo generation and get should be two functions - see also getInfotextContent
     */
    public function generateJavaScript(): void
    {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        if (!self::$jsIncluded) {
            $this->includeJavaScript($pageRenderer);
        }

        if ($this->markerclustererplus) {
            $pageRenderer->addJsFooterFile('EXT:ig_googlemaps/Resources/Public/UtilityLibrary/markerclustererplus/dist/markerclustererplus.min.js');
        }

        $controlsConfig = '';
        if ($this->controls)
            $controlsConfig = $this->getControlsConfig();

        $styleOutput = '';
        if ($this->customStyle) {
            $styleOutput = 'styles: ' . $this->customStyleText . ',';
        } else if ($this->style) {
            $theme = $this->getPartialView('Theme-' . $this->style, [], 'Themes/');
            $styleOutput = 'styles: ' . $theme->render() . ',';
        }

        // Map type
        $mapTypeOutput = $this->mapType ?: 'MapTypeId.ROADMAP';

        // Markers

        $js = '
            newMap = function(){
                let map;
                let marker = [];
                let autoOpen = [];
                function initialize() {
                    let latLng = new google.maps.LatLng(' . $this->latitude . ',' . $this->longitude . ');
                    let options = {
                        zoom: ' . ($this->zoom ?: 15) . ',
                        ' . $styleOutput . '
                        center: latLng,
                        mapTypeId: google.maps.' . $mapTypeOutput . '
                        ' . $controlsConfig . '
                    };
                    let mapElement = document.getElementById("' . $this->identifier . '");
                    map = new google.maps.Map(mapElement, options);';
        if ($this->autocalcmapcenter) {
            $js .= 'var bounds = new google.maps.LatLngBounds();';
        }

        $js .= $this->renderMarkers('map');
        $js .= $this->renderDirectionsService('map');
        if ($this->autocalcmapcenter) {
            if (count($this->markers) == 1) {
                $js .= 'map.setCenter(bounds.getCenter()); ';
            } else {
                $js .= '
                        map.fitBounds(bounds);
                        map.panToBounds(bounds);

                        document.querySelectorAll(".map-resize-trigger").forEach(function(mapResizeTrigger) {
                            mapResizeTrigger.addEventListener("click", function() {
                                map.fitBounds(bounds);
                            });
                        });
                ';

                if ($this->zoomChangeBoundsListener) {
                    $js .= '
                        zoomChangeBoundsListener = google.maps.event.addListenerOnce(map, \'bounds_changed\', function(event) {
                            if ( this.getZoom() ){   /* or set a minimum */
                                this.setZoom(options.zoom);  /* set zoom here */
                            }
                        });
                        setTimeout(function(){google.maps.event.removeListener(zoomChangeBoundsListener)}, 2000);
                    ';
                }
            }
        }

        $js .= '
                    google.maps.event.addListenerOnce(map, "idle", function() {
                        if(autoOpen.length > 0) {';
        if ($this->infowindowOfAllMarkersOpen) {
            $js .= 'for (var i = 0; i < autoOpen.length; i++) {
                               marker[autoOpen[i]].medInfoWindow.open(map, marker[autoOpen[i]]);
                            }';
        } else {
            $js .= 'marker[autoOpen[0]].medInfoWindow.open(map, marker[autoOpen[0]]);';
        }

        $js .= '}
                    });
                    /* accordion event (tx-iggooglemaps/inner-frame/ig-accordion) */
                    let parentElement = mapElement.parentElement.parentElement.parentElement;
                    if (parentElement.classList.contains("ig-accordion") && !parentElement.classList.contains("is-open")) {
                        let mapIsCentered = false;
                        parentElement.addEventListener("click", () => {
                            if(!mapIsCentered){
                                let currCenter = map.getCenter();
                                map.setCenter(currCenter);
                                map.fitBounds(bounds);
                                map.panToBounds(bounds);
                                mapIsCentered = true;
                            }
                        });
                    }
                }
                return initialize();
        };';
        if ($this->useConsentManager) {
            // fill array and call later
            $js .= '
                gMaps.push(newMap);
            ';
        } else {
            // call directly
            $js .= '
                newMap();
            ';
        }

        $pageRenderer->addFooterData('<script>' . $js . '</script>');
    }



    /**
     * Includes the javascript
     *
     * @return void
     */
    protected function includeJavaScript($pageRenderer)
    {
        $attrSrc = 'src';
        $callback = '&callback=mapsCallback';
        if ($this->useConsentManager) {
            $attrSrc = 'data-src';
        }

        // init map after api script is loaded
        $js = '
            let gMaps = [];
            let isMapsApiLoaded = false;
            window.mapsCallback = function () {
                isMapsApiLoaded = true;
                if(gMaps.length > 0){
                    for(let i = 0;i < gMaps.length;i++){
                        gMaps[i]();
                    }
                }
            };
        ';
        $pageRenderer->addFooterData('<script data-ignore="1">' . $js . '</script>');
        // Add JS files
        $pageRenderer->addFooterData('<script ' . $attrSrc . '="' . $this->apiUrl . '&key=' . $this->apiKey . $callback  . '" type="text/javascript" data-consent="googleMaps" data-ignore="1"></script>');
        if ($this->jsFile) {
            $filePath = PathUtility::getPublicResourceWebPath('EXT:ig_googlemaps/' . $this->jsFile);
            $pageRenderer->addFooterData('<script ' . $attrSrc . '="' . $filePath . '" type="text/javascript"></script>');
        }

        //END API Key Test
        //$pageRenderer->addJsFooterFile('EXT:ig_googlemaps'. $this->jsFile);

        self::$jsIncluded = true;
    }

    /**
     * Gets the controls configuration
     *
     * @return array
     */
    protected function getControlsConfig()
    {
        $controlsConfig = ',';

        foreach ($this->controls as $c) {
            if ($c == 'scaleControl') {
                $controlsConfig .= $c . ': true,';
            } else {
                $controlsConfig .= $c . ': false,';
            }
        }

        return substr($controlsConfig, 0, -1);
    }

    /**
     * Gets the infotextoutput for a marker
     *
     * @param Marker $marker
     * @return string
     */
    protected function getInfotextOutput($marker)
    {
        $infotext = $marker->getInfotext();
        if ($this->rteActivated) {
            $parseFuncTSPath = 'lib.parseFunc_RTE';
            $contentObject = GeneralUtility::makeInstance(ContentObjectRenderer::class);
            $contentObject->start([]);
            $infotext = $contentObject->parseFunc($infotext, [], '< ' . $parseFuncTSPath);
        }

        //$infotext = \TYPO3\CMS\Frontend\Plugin::pi_RTEcssText($marker->getInfotext(),
        // $cObj);
        // FS FIX '\n' wird nicht akzeptiert '\\n' oder "\n" verwenden */
        $infotext = str_replace(
            ["\r", "\n"],
            '',
            $infotext
        );

        //$infotext = str_replace("'",'&#39;',$infotext);

        return '<div class="ig_googlemaps_content">' . $infotext . '</div>';
    }

    /**
     * Gets the navigationoutput for a marker
     *
     * @param Marker $marker
     * @return string
     */
    protected function getNavigationOutput($marker)
    {
        // Config for fluid standalone view for markers
        $confArr = ['settings' => ['googleMapsSubmitClasses' => $this->googleMapsSubmitClasses], 'marker' => $marker];

        $navigation = $this->getPartialView('Navigation', $confArr);

        return $navigation->render();
    }

    /**
     * Gets the location link output for a marker
     *
     * @param Marker $marker
     * @return string
     */
    protected function getLocationLinkOutput($marker)
    {
        return '<a href="' . $marker->getLocationLink() . '" target="_blank">' . $GLOBALS['TSFE']->sL('LLL:EXT:ig_googlemaps/Resources/Private/Language/locallang.xlf:show_in_googlemaps') . '</a>';
    }

    /**
     * Gets the navigationoutput for a marker
     *
     * @param Marker $marker
     * @return string
     */
    protected function getShowInGooglemapsOutput($marker)
    {
        // Config for fluid standalone view for markers
        $confArr = ['marker' => $marker];

        $showInGooglemaps = $this->getPartialView('ShowInGooglemaps', $confArr);

        return $showInGooglemaps->render();
    }

    /**
     * Creates a standaloneview for a partial
     *
     * @param string $templateName
     * @param string $prefix
     * @return StandaloneView
     */
    protected function getPartialView($templateName, array $variables = [], $prefix = '')
    {
        //$context = GeneralUtility::makeInstance(RenderingContextFactory::class)->create();
        //$context->setControllerName('IgGooglemaps');
        $partialView = GeneralUtility::makeInstance(StandaloneView::class);
        //$extbaseAttribute->setControllerName('Maps');
        //$mvcRequest = GeneralUtility::makeInstance(Request::class, $request);
        //$request->withControllerExtensionName('IgGooglemaps'); // This should not be hardcoded, but how?
        if (method_exists($partialView, 'setRequest')) {
            $mvcRequest = $this->getMvcRequest('IgGooglemaps');
            $partialView->setRequest($mvcRequest);
        } else {
            // typo3 11.5
            $partialView->getRequest()->setControllerExtensionName('IgGooglemaps'); // This should not be hardcoded, but how?
        }

        $partialView->setFormat('html');
        $templateRootPath = 'EXT:ig_googlemaps/Resources/Private/Partials/';
        $templatePathAndFilename = $templateRootPath . $prefix . $templateName . '.html';
        $partialView->setTemplatePathAndFilename($templatePathAndFilename);
        $partialView->assignMultiple($variables);

        return $partialView;
    }

    /**
     * Get the value of Zoom Change Bounds Listener
     *
     * @return bool
     */
    public function getZoomChangeBoundsListener()
    {
        return $this->zoomChangeBoundsListener;
    }

    /**
     * Set the value of Zoom Change Bounds Listener
     *
     * @param bool $zoomChangeBoundsListener
     *
     * @return self
     */
    public function setZoomChangeBoundsListener($zoomChangeBoundsListener)
    {
        $this->zoomChangeBoundsListener = $zoomChangeBoundsListener;

        return $this;
    }

    protected function getMvcRequest(string $controllerExtensionName): Request
    {
        $extbaseAttribute = new ExtbaseRequestParameters();
        //$extbaseAttribute->setPluginName('IgGooglemaps');
        $extbaseAttribute->setControllerExtensionName($controllerExtensionName);

        $request = $this->getRequest()->withAttribute('extbase', $extbaseAttribute);
        return GeneralUtility::makeInstance(Request::class, $request);
    }

    protected function getRequest(): ServerRequestInterface
    {
        return $GLOBALS['TYPO3_REQUEST'];
    }
}
