<?php
namespace Ig\IgGooglemaps\ViewHelpers;

use Closure;
use Ig\IgGooglemaps\Domain\Model\Maps;
use TYPO3\CMS\Core\Configuration\ExtensionConfiguration;
use Internetgalerie\IgCookies\Utility\ConfigUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * ViewHelper for checking if a file has a category to set the checkbox
 */
class MapsViewHelper extends AbstractViewHelper  {
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * @var string Name of the extension this view helper belongs to
     */
    static protected $extensionName = 'IgGooglemaps';

    /**
     * @var string Name of the extension this view helper belongs to
     */
    static protected $pluginName = 'Maps';

    /**
     * @var ConfigurationManagerInterface
     */
    static protected $configurationManager;




    public function initializeArguments(): void {
        parent::initializeArguments();

        $this->registerArgument('infowindowOfAllMarkersOpen', 'bool', 'If the infowindow of all markers should be open at start', false, false);
        $this->registerArgument('identifier', 'string', 'The unique name of the map', false, 'map');
        $this->registerArgument('controls', 'array', 'The controls to deactivate', false, []);
        $this->registerArgument('deactivatePan', 'bool', 'Deactivate pan', false, false);
        $this->registerArgument('deactivateZoom', 'bool', 'Deactivate zoom', false, false);
        $this->registerArgument('deactivateMapType', 'bool', 'Deactivate map type', false, false);
        $this->registerArgument('deactivateScale', 'bool', 'Deactivate scale', false, false);
        $this->registerArgument('deactivateStreetview', 'bool', 'Deactivate streetview', false, false);
        $this->registerArgument('deactivateOverview', 'bool', 'Deactivate overview', false, false);
        $this->registerArgument('deactivateScrolling', 'bool', 'Deactivate scrolling', false, false);
        $this->registerArgument('markers', 'array', 'The markers on the map', false, null);
        $this->registerArgument('latitude', 'double', 'The latitude of the map center', false, 0);
        $this->registerArgument('longitude', 'double', 'The longitude of the map center', false, 0);
        $this->registerArgument('latlng', 'string', 'latitude,longitude of the map center', false, 0);
        $this->registerArgument('zoom', 'int', 'The default zoom', false, 0);
        $this->registerArgument('customStyle', 'bool', 'If the map has a custom style', false, false);
        $this->registerArgument('customStyleText', 'string', 'The custom style / theme of the map', false, []);
        $this->registerArgument('style', 'string', 'The style / theme of the map', false, '');
        $this->registerArgument('mapType', 'string', 'The type of the map', false, 'MapTypeId.ROADMAP');
        $this->registerArgument('googleMapsSubmitClasses', 'string', 'Classes added to the map', false, 'btn btn-primary');
        //$this->registerArgument('customMarkerPath', 'string', 'The path to the custom marker images', false, '');
        $this->registerArgument('customMarkerWidth', 'string', 'The width of the custom SVG Marker', false, '32');
        $this->registerArgument('customMarkerHeight', 'string', 'The height of the custom SVG Marker', false, '32');
        $this->registerArgument('autocalcmapcenter', 'bool', 'If the map center should be calculated automatically', false, false);
        $this->registerArgument('aspectRatio', 'string', 'The aspect ratio of the map', false, '');
        $this->registerArgument('width', 'string', 'The width of the map', false, '450px');
        $this->registerArgument('height', 'string', 'Height of the map', false, '250px');
        $this->registerArgument('rteActivated', 'bool', 'Use RTE for Marker Infotext', false, true);
        $this->registerArgument('markerclustererplus', 'bool', 'Use markerclustererplus', false, false);
        $this->registerArgument('markerClusterMaxZoom', 'int', 'maxZoom for markerCluster', false, 15);
        $this->registerArgument('apiUrl', 'string', 'Google Maps API', false, 'https://maps.googleapis.com/maps/api/js?v=3');
        $this->registerArgument('apiKey', 'string', 'Google Maps API Key', false, '');
        $this->registerArgument('jsFile', 'string', 'JS File', false, '');
        $this->registerArgument('zoomChangeBoundsListener', 'bool', 'Adjust Zoom after autocentering the map', false, true);
    }

    /**
     * @param array $arguments
     * @param Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     * @return bool
     */
    public static function renderStatic(
        array $arguments,
        Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    )
    {
        $map= GeneralUtility::makeInstance(Maps::class);
        //$templateVariableContainer = $this->renderingContext->getVariableProvider();
        $variableProvider=$renderingContext->getVariableProvider();
        $variableProvider->add('__igGooglemaps', [
            'directionsService' => [],
            'markers' => []
        ]);
        $renderChildrenClosure();
        if($variableProvider->exists('markers')) {
            $markers = $variableProvider->get('markers');
            $variableProvider->remove('markers');
        } else {
            $markers = [];
        }

        $__googleMap=$variableProvider->get('__igGooglemaps');
        $map->setDirectionsService($__googleMap['directionsService']);


        $deactivatePan = boolval($arguments['deactivatePan']);
        $deactivateZoom = boolval($arguments['deactivateZoom']);
        $deactivateMapType = boolval($arguments['deactivateMapType']);
        $deactivateScale = boolval($arguments['deactivateScale']);
        $deactivateStreetview = boolval($arguments['deactivateStreetview']);
        $deactivateOverview = boolval($arguments['deactivateOverview']);
        $deactivateScrolling = boolval($arguments['deactivateScrolling']);

        $controls = $arguments['controls'];

        if($deactivatePan && !in_array('panControl', $controls))
            $controls[] = 'panControl';

        if($deactivateZoom && !in_array('zoomControl', $controls))
            $controls[] = 'zoomControl';

        if($deactivateMapType && !in_array('mapTypeControl', $controls))
            $controls[] = 'mapTypeControl';

        if($deactivateScale && !in_array('streetViewControl', $controls))
            $controls[] = 'scaleControl';

        if($deactivateStreetview && !in_array('streetViewControl', $controls))
            $controls[] = 'streetViewControl';

        if($deactivateOverview && !in_array('overviewMapControl', $controls))
            $controls[] = 'overviewMapControl';

        if($deactivateScrolling && !in_array('scrollwheel', $controls))
            $controls[] = 'scrollwheel';

        $arguments['controls'] = $controls;

        $map->setIdentifier($arguments['identifier'] . '_' . Maps::$instanceCount);
        $map->setControls($arguments['controls']);
        $map->setMarkers($markers);
        $map->setMarkerclustererplus($arguments['markerclustererplus']);
        $map->setMarkerClusterMaxZoom($arguments['markerClusterMaxZoom']);
        $map->setInfowindowOfAllMarkersOpen(boolval($arguments['infowindowOfAllMarkersOpen']));
        if($arguments['latlng']) {
            $lat = NULL;
            $lng = NULL;
            //first priority: commaseparated string or array
            if (is_array($arguments['latlng'])) {
                if (isset($arguments['latlng']['lat'])) {
                    $lat = $arguments['latlng']['lat'];
                    $lng = $arguments['latlng']['lng'];
                } else {
                    $lat = $arguments['latlng'][0];
                    $lng = $arguments['latlng'][1];
                }
            } else {
                [$lat, $lng] = GeneralUtility::trimExplode(',', $arguments['latlng'], TRUE);
            }

            $map->setLatitude(doubleval($lat));
            $map->setLongitude(doubleval($lng));

        } else {
            $map->setLatitude(doubleval($arguments['latitude']));
            $map->setLongitude(doubleval($arguments['longitude']));
        }

        $map->setZoom(intval($arguments['zoom']));
        $map->setCustomStyle(boolval($arguments['customStyle']));
        $map->setCustomStyleText($arguments['customStyleText']);
        $map->setStyle($arguments['style']);
        $map->setMapType($arguments['mapType']);
        $map->setGoogleMapsSubmitClasses($arguments['googleMapsSubmitClasses']);
        //$map->setCustomMarkerPath($arguments['customMarkerPath']);
        $map->setCustomMarkerWidth($arguments['customMarkerWidth']);
        $map->setCustomMarkerHeight($arguments['customMarkerHeight']);
        $map->setAutocalcmapcenter(boolval($arguments['autocalcmapcenter']));
        $map->setAspectRatio($arguments['aspectRatio']);
        $map->setWidth($arguments['width']);
        $map->setHeight($arguments['height']);
        $map->setRteActivated($arguments['rteActivated']);
        $map->setApiUrl($arguments['apiUrl']);
        $map->setJsFile($arguments['jsFile']);

        if($arguments['apiKey']) {
            $map->setApiKey($arguments['apiKey']);
        } else {
            $all = static::getConfigurationManager()->getConfiguration(
                ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
            );

            $settings = $all['plugin.']['tx_iggooglemaps.']['settings.'];
            //$settings = $this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS, $this->extensionName, $this->pluginName);
            if( $settings['apiKey'] ) {
                $map->setApiKey($settings['apiKey']);
            } else {
                $extConf = GeneralUtility::makeInstance(
                    ExtensionConfiguration::class
                )->get('ig_googlemaps');
                $map->setApiKey($extConf['googleMapsGeocodingApiKey']);
            }
        }

        $zoomChangeBoundsListener = boolval($arguments['zoomChangeBoundsListener']);
        $map->setZoomChangeBoundsListener($zoomChangeBoundsListener);

        $map->generateJavaScript();

        $identifier = $map->getIdentifier();
        $aspectRatio = $map->getAspectRatio();
        $width = $map->getWidth();
        $height = $map->getHeight();

        // Create the outputstring
        $content = '<div id="'. $identifier . '"';

        if($aspectRatio)
            $content .= ' class="map_aspect_ratio_' . $aspectRatio . '"';

        $content .= ' style="width: ' . $width;

        if(!$aspectRatio)
            $content .= '; height: '. $height;

        $placeholder = '';
        $dataAttribute = '';
        // this should be a event
        if (class_exists(ConfigUtility::class) && ConfigUtility::isActive()) {
            $dataAttribute = ' data-consent="googleMaps"';
        }

        $content .= ';"' . $dataAttribute . '>'. $placeholder.'</div>';
        $content .= $map->getInfotextContent();

        return $content;
    }

    /**
     * Returns instance of the configuration manager
     *
     * @return ConfigurationManagerInterface
     */
    protected static function getConfigurationManager()
    {
        if (null !== static::$configurationManager) {
            return static::$configurationManager;
        }

        $configurationManager = GeneralUtility::makeInstance(ConfigurationManagerInterface::class);
        static::$configurationManager = $configurationManager;
        return $configurationManager;
    }
}
