<?php
declare(strict_types = 1);

namespace Internetgalerie\IgHideInSitemap\DataProcessing;

use TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer;
use TYPO3\CMS\Frontend\DataProcessing\MenuProcessor;

/**
 * tt_content.menu_sitemap_pages.dataProcessing.10 = sitemapmenu
 * instead of
 * tt_content.menu_sitemap_pages.dataProcessing.10 = menu
 */


class SitemapMenuProcessor extends MenuProcessor
{

    // remove elements with ig_hide_in_sitemap == 1 recursively
    function filterSitemap(&$array)
    {
        foreach ($array as $key => &$item) {
            if ($item['data']['ig_hide_in_sitemap'] ?? false) {
                unset($array[$key]);
            } else {
                if (!empty($item['children'])) {
                    $this->filterSitemap($item['children']);
                }
            }
        }
    }

    public function process(
        ContentObjectRenderer $cObj,
        array $contentObjectConfiguration,
        array $processorConfiguration,
        array $processedData
    ) {
        $processedData = parent::process($cObj, $contentObjectConfiguration, $processorConfiguration, $processedData);
        $this->filterSitemap($processedData[$this->menuTargetVariableName]);
        return $processedData;
    }
}
