(function($) {
    $.fn.iggalerie = function(args) {
        var defaults = {

            debug : false, /* Debug Aktivieren/Deaktivieren */
            touchswipe : false, /* Touch Swipe Aktivieren/Deaktivieren */
            slideshow : false, /* Slideshow Autostart Aktivieren/Dekativieren */
            // Damit der bg-slider korrekt skaliert muss cssFallback auf true gesetzt sein
            heightBugfix : true, /* Chrome "Height 100%"-Bugfix Aktivieren/Dekativieren */
            animationdnd : 0,
            slideshowtime : 3000, /* Standard Slideshow Time */
            keyBinding : true, /* key usage */
            cssFallback : true,
            galerieMode : false, /* highAspectMode or */
            isMultiLayer : false
        };

        this.each(function() {

            var settings = $.extend({}, defaults, args);
            var iggalerie,
                iggalerieHolder,
                sliderInterval;
            // Schnellzugrifsvariabeln
            iggalerie = $(this);
            settings.isMultiLayer = iggalerie.parent().parent().hasClass('multilayer');
            iggalerieHolder = $(this).children(".ig-galerie-holder");
            var phgalerieHolder = $(this).children(".pageHeader-galerie-holder");

            if (iggalerie.hasClass("highAspectMode")) {
                settings.galerieMode = "highAspectMode";
            } else if ((iggalerie.hasClass("autoSkaleMode")) || ($(iggalerie).hasClass("ig-bgslider"))) {
                settings.galerieMode = "autoSkaleMode";
            }
            if (settings.debug)
                console.log("Galerie Mode:" + settings.galerieMode);

            /*Chrome Bugfix, Setzte Höhe per JS*/
            if (settings.heightBugfix) {

                setCurrentHeight();

                $(window).smartresize(setCurrentHeight);

                $(window).bind("load", function() {
                    setCurrentHeight();
                });
            }

            /**
             * Generiere Erweiterte Navigation
             * Einstellungen: Aus Klasse .ig-galerie-extendNav Wert: data-style
             * Möglich: dotts, thumbnails
             *
             * Todo: Sollte durch Typoscript ersetzt werden
             */
            if (iggalerie.children(".ig-galerie-extendNav")) {

                switch(iggalerie.children(".ig-galerie-extendNav").data("style")) {
                default:
                    break;
                case "dotts":
                    if (settings.debug)
                        console.log("dotts");

                    iggalerieHolder.children("div").each(function() {
                        if (settings.debug)
                            console.log(this);
                        iggalerie.children(".ig-galerie-extendNav").append("<span class='ig-galerie-handler' data-move='" + this.id + "'>" + this.id + "</span>");

                    });
                    break;

                case "thumbnails":
                    if (settings.debug)
                        console.log("thumbnails");

                    iggalerieHolder.children("div").each(function() {
                        if (settings.debug)
                            console.log(this);
                        var thumbnail = "";
                        thumbnail += "<span class='ig-galerie-handler' data-move='" + this.id + "'>";

                        /*Teste Ob Picture Element zur Verfügung. Falls ja, nehme das erste*/
                        if ($(this).find(".responsiveimg").length) {
                            if (settings.debug)
                                console.log("Element" + this.id + "hat ein Picture Element" + $(this).find("object").attr("src"));
                            //thumbnail += "<img class='ig-galerie-thumbnail' src='" + $(this).find("object").attr("src") + "' />";
                            thumbnail += "<img class='ig-galerie-thumbnail' src='" + $(this).find('.responsiveimg').children().first().attr("src") + "' />";

                        } else {
                            thumbnail += "<img class='ig-galerie-thumbnail' src='/typo3conf/ext/ig_layout/Resources/Public/Images/iconfiles/pdf_over.png' />";
                        }

                        thumbnail += "</span>";
                        iggalerie.children(".ig-galerie-extendNav").append(thumbnail);

                    });
                    break;

                }
            }

            /**
             * Aktualisiere Defaultwerte für Instanz
             *
             * animationdnd data-animationdnd = 0/1
             * animationtime data-slideshowtime = INT (s)
             * slideshowtime data-animationtime = Float (s)
             * noSwipe data-swipe = boolean
             */
            if (iggalerieHolder.data('animationdnd') == 1) {
                settings.animationdnd = iggalerieHolder.data('animationtime');
            }
            if (iggalerieHolder.data('slideshowtime') != '') {
                settings.slideshowtime = 1000 * iggalerieHolder.data('slideshowtime');
            }
            if (iggalerieHolder.data('animationtime') != '') {
                settings.animationtime = iggalerieHolder.data('animationtime');
                setAnimationTime();
            }
            if (iggalerieHolder.data('swipe') == 0) {
                settings.touchswipe = true;
            }

            /**
             * Initialisiere Galerie
             * Setze erstes Element als Aktiv ( moveTo(first) )
             * entferne Inactiv Klasse
             */
            if (iggalerie.hasClass("inactive")) {
                moveTo("first");
                iggalerie.removeClass("inactive");
            }

            /**
             * Initialisiere Handler
             * Aktiviere Klick Handler mit DnD
             */
            if (iggalerie.has(".ig-galerie-handler")) {

                var debouncetime = new Date().getTime() - (settings.animationdnd * 1000);
                iggalerie.find(".ig-galerie-handler").click(function() {

                    if (debouncetime + (settings.animationdnd * 1000) < new Date().getTime()) {
                        moveTo($(this).data("move"));
                        debouncetime = new Date().getTime();
                        slideshowStop();
                    }
                });

            }

            // Adding support for handlers outside of the gallery
            $(".ig-galerie-handler[data-gallery='" + iggalerie.attr('id') + "']").click(function() {
                if (debouncetime + (settings.animationdnd * 1000) < new Date().getTime()) {
                    moveTo($(this).data("move"));
                    debouncetime = new Date().getTime();
                    slideshowStop();
                }
            });

            /**
             * Initialisiere TouchSwipe
             *
             * ToDo: Kontrolle ob TouchSwipe Erweiterung geladen ist.
             * evl. mit Timer um assync laden zu ermöglichen
             */
            if (settings.touchswipe) {
                if (settings.debug)
                    console.log("touchswipe aktiviert");
                $(this).children(".ig-galerie-holder").swipe({
                    swipe : function(event, direction, distance, duration, fingerCount) {
                        switch (direction) {

                        case "right":
                            moveTo("prev");
                            slideshowStop();
                            break;
                        case "left":
                            moveTo("next");
                            slideshowStop();
                            break;
                        }
                    },
                    allowPageScroll : 'vertical',
                    threshold : 20
                });
            }

            if (settings.keyBinding) {
                $('html').keydown(function(e) {

                    // Go to image x with number x-key
                    // only works for the gridgallery
                    if (e.which >= 49 && e.which <= 57) {
                        moveTo("img-" + (e.which - 48));
                    }

                    // right and up arrow
                    if (e.which == "39" || e.which == "38") {
                        slideshowStop();
                        moveTo("next", true);
                    }

                    // left and down arrow
                    if (e.which == "37" || e.which == "40") {
                        moveTo("prev", true);
                        slideshowStop();
                    }
                    // esc to stop
                    if (e.which == "27") {
                        slideshowStop();
                    }
                    // enter to start (on 1 or last gallery possible)
                    if (e.which == "13") {
                        slideshowStop();
                        slideshowStart();
                    }

                });
            }
            /**
             * CSS Fallback (IE8)
             *
             * Setzte Positionsangaben falls CSS nicht greift. (Wird auch bei zu vielen Galerieeinträgen benützt)
             */
            if (settings.cssFallback) {
                iggalerieHolder.children("div").each(function(index) {
                    if ((isNaN(parseInt($(this).css("left")))) || (parseInt($(this).css("left")) == 0)) {
                        $(this).css("left", (index * -100) + "%");
                    };
                });
            }

            /**
             * Initialisiere Autostart Slideshow
             * Einstellungen: Aus Klasse .ig-galerie zusätzliche Klasse .slideshowstart
             *
             */
            if ((settings.slideshow) || (iggalerie.hasClass("slideshowstart"))) {
                slideshow("start");
            }

            /**
             * Setzt die .active Klassen auf das aktive Element sowie eine
             * Klasse auf das Linke (lactive) und Rechte (ractive) Element
             * Zusätzlich die ".animate" Klasse auf das aktive sowie auf das
             * nächste zu animierende Element.
             *
             * @param {String} direction
             *      direction kann einer der folgenden Strings sein:
             *       - Eine ID zu der gewechselt wird. Wird für Thumbnails verwendet.
             *       - first: Wechselt zum ersten Bild
             *       - next: Wechselt zum nächsten Bild
             *       - prev: Wechselt zum vorherigen Bild
             *       - start: Aktiviert die Slideshow
             *       - stop: Stoppt die Slideshow
             * @param {Boolean} executeOnce
             *      Wenn true werden nicht alle Layer durchlaufen sondern nur der eigene. Wird benutzt damit
             *      die Keyboard-Shortcuts korrekt funktionieren.
             * @return {void}
             */
            function moveTo(direction, executeOnce) {
                var numberOfElements = iggalerieHolder.children().length;
                executeOnce = ( typeof (executeOnce) === "boolean") && executeOnce;

                // When direction is an id
                if (iggalerieHolder.find("#" + direction).length > 0) {
                    var moveToId = "#" + direction;

                    // We only need to change classes if the clicked element is not already active
                    if (!$(moveToId).hasClass("active")) {

                        // Remove existing classes from all slides
                        iggalerieHolder.children("div").removeClass("active lactive ractive animate");

                        // Add .active class to clicked element
                        iggalerieHolder.children(moveToId).addClass("animate active");
                        var $activeElement = iggalerieHolder.children(".active").first();

                        // Add lactive class to the correct element
                        if ($activeElement.is(':first-child')) {
                            iggalerieHolder.children("div:last-child").addClass("animate lactive");
                        } else {
                            $activeElement.prev().addClass("animate lactive");
                        }

                        // Add ractive class to the correct element
                        if ($activeElement.is(':last-child')) {
                            iggalerieHolder.children("div:first-child").addClass("animate ractive");
                        } else {
                            $activeElement.next().addClass("animate ractive");
                        }
                    }
                } else {
                    switch(direction) {

                    // Sets the first element in the slider as activate
                    case "first":
                        iggalerieHolder.children("div").removeClass("lactive ractive animate");
                        iggalerieHolder.children(".active").removeClass("active");

                        iggalerieHolder.children("div:first-child").addClass("animate active");
                        if (numberOfElements > 1) {
                            iggalerieHolder.children("div:last-child").addClass("animate lactive");
                            iggalerieHolder.children(".active").next().addClass("ractive animate");
                        }

                        break;

                    // Switch to the next image
                    case "next":
                        if (settings.isMultiLayer && !executeOnce) {

                            var $layerContainer = iggalerieHolder.parents(".layer-container");
                            if ($layerContainer.find(".ig-galerie-holder").length > 1) {
                                $layerContainer.find(".ig-galerie-holder").each(function() {
                                    var holder = $(this);

                                    holder.children("div").removeClass("lactive ractive animate");
                                    holder.children(".active").addClass("animate lactive").removeClass("active");

                                    if (holder.children(".lactive").is(':last-child')) {
                                        holder.children("div:first-child").addClass("animate active");
                                    } else {
                                        holder.children(".lactive").next().addClass("animate active");
                                    }

                                    if (holder.children(".active").is(':last-child')) {
                                        holder.children("div:first-child").addClass("ractive");
                                    } else {
                                        holder.children(".active").next().addClass("ractive");
                                    }
                                });
                            }
                        } else {
                            if (numberOfElements > 1) {
                                iggalerieHolder.children("div").removeClass("lactive ractive animate");
                                iggalerieHolder.children(".active").addClass("animate lactive").removeClass("active");

                                if (iggalerieHolder.children(".lactive").is(':last-child')) {
                                    iggalerieHolder.children("div:first-child").addClass("animate active");
                                } else {
                                    iggalerieHolder.children(".lactive").next().addClass("animate active");
                                }

                                if (iggalerieHolder.children(".active").is(':last-child')) {
                                    iggalerieHolder.children("div:first-child").addClass("ractive");
                                } else {
                                    iggalerieHolder.children(".active").next().addClass("ractive");
                                }
                            }
                        }

                        break;

                    // Switch to the previous image
                    case "prev":
                        if (settings.isMultiLayer && !executeOnce) {
                            var $layerContainer = iggalerieHolder.parents(".layer-container");
                            if ($layerContainer.find(".ig-galerie-holder").length > 1) {
                                $layerContainer.find(".ig-galerie-holder").each(function() {
                                    var holder = $(this);

                                    holder.children("div").removeClass("lactive ractive animate");
                                    holder.children(".active").addClass("animate ractive").removeClass("active");

                                    if (holder.children(".ractive").is(':first-child')) {
                                        holder.children("div:last-child").addClass("animate active");
                                    } else {
                                        holder.children(".ractive").prev().addClass("animate active");
                                    }

                                    if (holder.children(".active").is(':first-child')) {
                                        holder.children("div:last-child").addClass("animate lactive");
                                    } else {
                                        holder.children(".active").prev().addClass("lactive");
                                    }
                                });
                            }

                        } else {
                            if (numberOfElements > 1) {
                                iggalerieHolder.children("div").removeClass("lactive ractive animate");
                                iggalerieHolder.children(".active").addClass("animate ractive").removeClass("active");

                                if (iggalerieHolder.children(".ractive").is(':first-child')) {
                                    iggalerieHolder.children("div:last-child").addClass("animate active");
                                } else {
                                    iggalerieHolder.children(".ractive").prev().addClass("animate active");
                                }

                                if (iggalerieHolder.children(".active").is(':first-child')) {
                                    iggalerieHolder.children("div:last-child").addClass("animate lactive");
                                } else {
                                    iggalerieHolder.children(".active").prev().addClass("lactive");
                                }
                            }
                        }

                        break;

                    // Start or stop the slideshow
                    case "start":
                    case "stop":
                        if (defaults.slideshow == true)
                            slideshow(direction);
                        break;

                    default:
                        //console.log("No supported direction:", direction);
                        break;
                    }

                    if (settings.debug) {
                        console.log(direction);
                    }
                }

                //Setzte aktive Element auf ig-handler
		if(iggalerie.find(".ig-galerie-handler").length) {
                    iggalerie.find(".ig-galerie-handler").removeClass("active");
                    iggalerie.find("[data-move='" + iggalerieHolder.children(".active").attr('id') + "']").addClass("active");
		}
            }

            function slideshow(init) {
                switch (init) {
                case "start":
                    if (settings.debug)
                        console.log("slideshow Start setzten");
                    slideshowStart();
                    break;
                case "stop":
                    if (settings.debug)
                        console.log("slideshow stop");
                    //console.log("success!");
                    slideshowStop();
                    break;
                default:
                    if (settings.debug)
                        console.log("slideshow Start default");
                    break;
                }
            }

            function slideshowStart() {
                sliderInterval = setInterval(function() {
                    moveTo('next');
                }, settings.slideshowtime);
                //console.log("STARTED");
            }

            function slideshowStop() {
                if (settings.debug)
                    console.log("Slideshow gestoppt");

                if (settings.debug)
                    console.log("SLIDERINTERVAL: " + sliderInterval);

                clearInterval(sliderInterval);
                if (settings.debug)
                    console.log("CLEARED!");
            }

            function setCurrentHeight() {

                if (settings.galerieMode == "autoSkaleMode") {

                    var theWindow = $(iggalerieHolder);
                    var phWindow = $(phgalerieHolder);

                    $(iggalerieHolder).children("div").find(".csc-textpic-imagewrap").each(function() {

                        var $bg = $(this),
                            aspectRatio = $bg.find("img").width() / $bg.find("img").height();

                        if ((theWindow.width() / theWindow.height() ) < aspectRatio) {
                            $bg.removeClass("bgwidth").addClass('bgheight');
                        } else {
                            $bg.removeClass("bgheight").addClass('bgwidth');
                        }

                    });

                    $(phgalerieHolder).children("div").find(".csc-textpic-imagewrap").each(function() {

                        var $bg = $(this),
                            aspectRatio = $bg.find("img").width() / $bg.find("img").height();

                        if ((phWindow.width() / phWindow.height() ) < aspectRatio) {
                            $bg.removeClass("bgwidth").addClass('bgheight');
                        } else {
                            $bg.removeClass("bgheight").addClass('bgwidth');
                        }

                    });

                } else if (settings.galerieMode == "highAspectMode") {

                    // Dieser Fallback wird schon lange nicht mehr benötigt.
                    return;
		    /*
                    var textpic_imagewrap = $(iggalerieHolder).find(".csc-textpic-imagewrap").height();
                    iggalerieHolder.children("div").removeClass("animate").find(".csc-textpic-imagewrap").children("div").height(textpic_imagewrap);
                    $(".layer-4 .ig-galerie-holder .csc-default").height(textpic_imagewrap);

                    var textpic_imagewrap = $(phgalerieHolder).find(".csc-textpic-imagewrap").height();
                    phgalerieHolder.children("div").removeClass("animate").find(".csc-textpic-imagewrap").children("div").height(textpic_imagewrap);
		    */
                }
            }

            function setAnimationTime() {
                var galerieId = iggalerie.parent().attr('id');
                if (!galerieId) {
                    galerieId = "html";
                } else {
                    galerieId = "#" + galerieId;
                }
                $('head').append('<style type="text/css">' + galerieId + ' .ig-galerie .animate{transition: ' + settings.animationtime + 's ease-in-out;}</style>');
            }

        });

    };
    // sofort initialisieren
    $(document).ready(function() {
        //igGalerie
        if ($(".ig-galerie"))
            $(".ig-galerie").iggalerie();
    });
    $(window).bind("load", function() {
        $(".ig-galerie").each(function() {
            $(this).find('.ig-galerie-handler span').height(parseInt($(this).find('.ig-galerie-holder > div').height() + parseInt($(this).find('.ig-galerie-holder > div').css('padding-top'))));
        });
    });
    $(window).smartresize(function() {
        $(".ig-galerie").each(function() {
            $(this).find('.ig-galerie-handler span').height(parseInt($(this).find('.ig-galerie-holder > div').height() + parseInt($(this).find('.ig-galerie-holder > div').css('padding-top'))));
        });
    });
})(jQuery);
