<?php

namespace Internetgalerie\IgJavascript\Render;

use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Core\Http\ApplicationType;
use TYPO3\CMS\Core\Localization\LanguageService;
use TYPO3\CMS\Core\TypoScript\TypoScriptService;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;

class PostProcess
{

    public function __construct(
        protected readonly TypoScriptService $typoScriptService,
        protected readonly ConfigurationManagerInterface $configurationManager,
    ) {
    }

    public function addInline(&$params, &$obj)
    {
        if (!$this->isFrontend()) {
            return;
        }
        $js = '';
        $all = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
        );
        $letStringArray = $this->typoScriptService->convertTypoScriptArrayToPlainArray($all['plugin.']['tx_igjavascript.']['let.'] ?? []);
        // inline variables
        $letArray = $this->convertStringArray($letStringArray);
        if (!empty($letArray)) {
            foreach ($letArray as $name => $value) {
                // value is a language file, include labels
                if (is_string( $value) && substr($value, 0, 8) == 'LLL:EXT:') {
                    $languageService =$this->getLanguageService();
                    $languageFilename = substr($value, 4);
                    $languageArray = $languageService->getLabelsFromResource($languageFilename);
                    $value = json_encode($languageArray, JSON_UNESCAPED_UNICODE);
               } else {
                    // use as object
                   $value = json_encode($value, JSON_FORCE_OBJECT);
                   // remove quotes around the keys (maybe not very usefull)
                   $value = preg_replace('/"([^"]+)":/', '$1:', $value);
               }
                $js .= 'let ' . $name . '=' .  $value . ';';
            }
        }
        
        // inline JS
        $tsJsInline = $all['plugin.']['tx_igjavascript.']['jsInline.'] ?? [];
        if (!empty($tsJsInline)) {
            $jsParts = [];
            // sort
            ksort($tsJsInline);
            foreach ($tsJsInline as $jsInline) {
                if ($jsInline) {
                    $js .= $jsInline;
                }
            }
        }
        if ($js) {
            $params['jsFooterLibs'] =  $this->wrapInlineScript($js, ['data-ignore' => 1]) . $params['jsFooterLibs'];
        }
    }

    function convertStringArray(array $stringArray) {
        $convertedArray = [];
        foreach ($stringArray as $name => $element) {
            if (is_array($element)) {
                $convertedArray[$name] = $this->convertStringArray($element); // Recursively convert nested arrays
            } elseif (is_numeric($element)) {
                if (strpos($element, '.') !== false) {
                    $convertedArray[$name] = (float)$element; // Convert to float
                } else {
                    $convertedArray[$name] = (int)$element; // Convert to integer
                }
            } elseif (is_bool($element)) {
                $convertedArray[$name] = (bool)$element; // Convert to boolean
            } else {
                $convertedArray[$name] = $element; // Keep it as string
            }
        }   
        return $convertedArray;
    }

    protected function wrapInlineScript(string $content, array $attributes = []): string
    {
        $attributesList = GeneralUtility::implodeAttributes($attributes, true);
        return "<script" . ($attributesList !== '' ? ' ' . $attributesList : '') . ">\n/*<![CDATA[*/\n" . $content . "\n/*]]>*/\n</script>";
    }

    public function isFrontend(): bool
    {
        return ($GLOBALS['TYPO3_REQUEST'] ?? null) instanceof ServerRequestInterface &&
            ApplicationType::fromRequest($GLOBALS['TYPO3_REQUEST'])->isFrontend();
    }
    protected static function getLanguageService(): LanguageService
    {
        return $GLOBALS['LANG'];
    }
}
