<?php
namespace Ig\IgJobs\Controller;

use Ig\IgJobs\Domain\Model\Category;
use Ig\IgJobs\Domain\Repository\CategoryRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/***
 *
 * This file is part of the "SBK Job Database" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2018 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * CategoryController
 */
class CategoryController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{
    protected CategoryRepository $categoryRepository;

    public function __construct(CategoryRepository $categoryRepository)
    {
        $this->categoryRepository = $categoryRepository;
    }

    public function initializeAction(): void
    {
        parent::initializeAction();
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addJsFooterFile('EXT:ig_jobs/Resources/Public/JavaScript/ig_jobs.js');
    }

    /**
     * action list
     *
     * @return void
     */
    public function listAction(): ResponseInterface
    {
        $categories = $this->categoryRepository->findAll();
        $this->view->assign('categories', $categories);

        return $this->htmlResponse();
    }

    /**
     * action new
     *
     * @return void
     */
    public function newAction(): ResponseInterface
    {
        return $this->htmlResponse();
    }

    /**
     * action create
     *
     * @param \Ig\IgJobs\Domain\Model\Category $newCategory
     * @return void
     */
    public function createAction(Category $newCategory): ResponseInterface
    {
        $this->addFlashMessage('The object was created. Please be aware that this action is publicly accessible unless you implement an access check. See https://docs.typo3.org/typo3cms/extensions/extension_builder/User/Index.html', '', ContextualFeedbackSeverity::WARNING);
        $this->categoryRepository->add($newCategory);
        return $this->redirect('list');
    }

    /**
     * action edit
     *
     * @param \Ig\IgJobs\Domain\Model\Category $category
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation("category")
     * @return void
     */
    public function editAction(Category $category): ResponseInterface
    {
        $this->view->assign('category', $category);

        return $this->htmlResponse();
    }

    /**
     * action update
     *
     * @param \Ig\IgJobs\Domain\Model\Category $category
     * @return void
     */
    public function updateAction(Category $category): ResponseInterface
    {
        $this->addFlashMessage('The object was updated. Please be aware that this action is publicly accessible unless you implement an access check. See https://docs.typo3.org/typo3cms/extensions/extension_builder/User/Index.html', '', ContextualFeedbackSeverity::WARNING);
        $this->categoryRepository->update($category);
        return $this->redirect('list');
    }

    /**
     * action delete
     *
     * @param \Ig\IgJobs\Domain\Model\Category $category
     * @return void
     */
    public function deleteAction(Category $category): ResponseInterface
    {
        $this->addFlashMessage('The object was deleted. Please be aware that this action is publicly accessible unless you implement an access check. See https://docs.typo3.org/typo3cms/extensions/extension_builder/User/Index.html', '', ContextualFeedbackSeverity::WARNING);
        $this->categoryRepository->remove($category);
        return $this->redirect('list');
    }
}
