<?php
namespace Ig\IgJobs\Controller;

use Ig\IgJobs\Domain\Model\Employment;
use Ig\IgJobs\Domain\Repository\EmploymentRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/***
 *
 * This file is part of the "SBK Job Database" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2018 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * EmploymentController
 */
class EmploymentController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{
    protected EmploymentRepository $employmentRepository;

    public function __construct(EmploymentRepository $employmentRepository)
    {
        $this->employmentRepository = $employmentRepository;
    }

    public function initializeAction(): void
    {
        parent::initializeAction();
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addJsFooterFile('EXT:ig_jobs/Resources/Public/JavaScript/ig_jobs.js');
    }

    /**
     * action list
     *
     * @return void
     */
    public function listAction(): ResponseInterface
    {
        $employments = $this->employmentRepository->findAll();
        $this->view->assign('employments', $employments);

        return $this->htmlResponse();
    }

    /**
     * action new
     *
     * @return void
     */
    public function newAction(): ResponseInterface
    {
        return $this->htmlResponse();
    }

    /**
     * action create
     *
     * @param \Ig\IgJobs\Domain\Model\Employment $newEmployment
     * @return void
     */
    public function createAction(Employment $newEmployment): ResponseInterface
    {
        $this->addFlashMessage('The object was created. Please be aware that this action is publicly accessible unless you implement an access check. See https://docs.typo3.org/typo3cms/extensions/extension_builder/User/Index.html', '', ContextualFeedbackSeverity::WARNING);
        $this->employmentRepository->add($newEmployment);
        return $this->redirect('list');
    }

    /**
     * action edit
     *
     * @param \Ig\IgJobs\Domain\Model\Employment $employment
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation("employment")
     * @return void
     */
    public function editAction(Employment $employment): ResponseInterface
    {
        $this->view->assign('employment', $employment);

        return $this->htmlResponse();
    }

    /**
     * action update
     *
     * @param \Ig\IgJobs\Domain\Model\Employment $employment
     * @return void
     */
    public function updateAction(Employment $employment): ResponseInterface
    {
        $this->addFlashMessage('The object was updated. Please be aware that this action is publicly accessible unless you implement an access check. See https://docs.typo3.org/typo3cms/extensions/extension_builder/User/Index.html', '', ContextualFeedbackSeverity::WARNING);
        $this->employmentRepository->update($employment);
        return $this->redirect('list');
    }

    /**
     * action delete
     *
     * @param \Ig\IgJobs\Domain\Model\Employment $employment
     * @return void
     */
    public function deleteAction(Employment $employment): ResponseInterface
    {
        $this->addFlashMessage('The object was deleted. Please be aware that this action is publicly accessible unless you implement an access check. See https://docs.typo3.org/typo3cms/extensions/extension_builder/User/Index.html', '', ContextualFeedbackSeverity::WARNING);
        $this->employmentRepository->remove($employment);
        return $this->redirect('list');
    }
}
