<?php
namespace Ig\IgJobs\Domain\Model;

/***
 *
 * This file is part of the "SBK Job Database" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2018
 *
 ***/

/**
 * Application
 */
class Application extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * gender
     *
     * @var int
     */
    protected $gender = 0;

    /**
     * firstName
     *
     * @var string
     */
    protected $firstName = '';

    /**
     * lastName
     *
     * @var string
     */
    protected $lastName = '';

    /**
     * address
     *
     * @var string
     */
    protected $address = '';

    /**
     * addressAdditional
     *
     * @var string
     */
    protected $addressAdditional = '';

    /**
     * zipCity
     *
     * @var string
     */
    protected $zipCity = '';

    /**
     * phone
     *
     * @var string
     */
    protected $phone = '';

    /**
     * mobile
     *
     * @var string
     */
    protected $mobile = '';

    /**
     * email
     *
     * @var string
     */
    protected $email = '';

    /**
     * message
     *
     * @var string
     */
    protected $message = '';

    /**
     * birthDate
     *
     * @var string
     */
    protected $birthDate = '';

    /**
     * applicationLetter
     *
     * @var string
     */
    protected $applicationLetter = '';

    /**
     * attentionOther
     *
     * @var string
     */
    protected $attentionOther = '';

    /**
     * attention
     *
     * @var \Ig\IgJobs\Domain\Model\Attention
     */
    protected $attention = '';

    /**
     * The documents
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference>
     */
    protected $documents = null;

    /**
     * curriculumVitae
     *
     * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $curriculumVitae = null;

    /**
     * jobReferences
     *
     * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $jobReferences = null;

    /**
     * diplomas
     *
     * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $diplomas = null;

    /**
     * file1
     *
     * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $file1 = null;

    /**
     * file2
     *
     * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $file2 = null;

    /**
     * file3
     *
     * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $file3 = null;

    /**
     * file4
     *
     * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $file4 = null;

    /**
     * applicationLetterFile
     *
     * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $applicationLetterFile = null;

    /**
     * position
     *
     * @var \Ig\IgJobs\Domain\Model\Position
     */
    protected $position = null;

    /**
     * captcha (Not persisted, just for validation)
     *
     * @var string
     * @TYPO3\CMS\Extbase\Annotation\Validate("\Evoweb\Recaptcha\Validation\RecaptchaValidator")
     */
    protected $captchaResponse = '';

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     *
     * @return void
     */
    protected function initStorageObjects()
    {
        $this->documents = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        /*$this->curriculumVitae = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->jobReferences = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->diplomas = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->file1 = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->applicationLetterFile = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();*/
    }

    /**
     * Returns the gender
     *
     * @return int $gender
     */
    public function getGender()
    {
        return $this->gender;
    }

    /**
     * Sets the gender
     *
     * @param int $gender
     * @return void
     */
    public function setGender($gender)
    {
        $this->gender = $gender;
    }

    /**
     * Returns the firstName
     *
     * @return string $firstName
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * Sets the firstName
     *
     * @param string $firstName
     * @return void
     */
    public function setFirstName($firstName)
    {
        $this->firstName = $firstName;
    }

    /**
     * Returns the lastName
     *
     * @return string $lastName
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * Sets the lastName
     *
     * @param string $lastName
     * @return void
     */
    public function setLastName($lastName)
    {
        $this->lastName = $lastName;
    }

    /**
     * Returns the address
     *
     * @return string $address
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * Sets the address
     *
     * @param string $address
     * @return void
     */
    public function setAddress($address)
    {
        $this->address = $address;
    }

    /**
     * Returns the addressAdditional
     *
     * @return string $addressAdditional
     */
    public function getAddressAdditional()
    {
        return $this->addressAdditional;
    }

    /**
     * Sets the addressAdditional
     *
     * @param string $addressAdditional
     * @return void
     */
    public function setAddressAdditional($addressAdditional)
    {
        $this->addressAdditional = $addressAdditional;
    }

    /**
     * Returns the zipCity
     *
     * @return string $zipCity
     */
    public function getZipCity()
    {
        return $this->zipCity;
    }

    /**
     * Sets the zipCity
     *
     * @param string $zipCity
     * @return void
     */
    public function setZipCity($zipCity)
    {
        $this->zipCity = $zipCity;
    }

    /**
     * Returns the phone
     *
     * @return string $phone
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Sets the phone
     *
     * @param string $phone
     * @return void
     */
    public function setPhone($phone)
    {
        $this->phone = $phone;
    }

    /**
     * Returns the mobile
     *
     * @return string $mobile
     */
    public function getMobile()
    {
        return $this->mobile;
    }

    /**
     * Sets the mobile
     *
     * @param string $mobile
     * @return void
     */
    public function setMobile($mobile)
    {
        $this->mobile = $mobile;
    }

    /**
     * Returns the email
     *
     * @return string $email
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Sets the email
     *
     * @param string $email
     * @return void
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }

    /**
     * Returns the message
     *
     * @return string $message
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * Sets the message
     *
     * @param string $message
     * @return void
     */
    public function setMessage($message)
    {
        $this->message = $message;
    }

    /**
     * Returns the birthDate
     *
     * @return string $birthDate
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }

    /**
     * Sets the birthDate
     *
     * @param string $birthDate
     * @return void
     */
    public function setBirthDate($birthDate)
    {
        $this->birthDate = $birthDate;
    }

    /**
     * Returns the applicationLetter
     *
     * @return string $applicationLetter
     */
    public function getApplicationLetter()
    {
        return $this->applicationLetter;
    }

    /**
     * Sets the applicationLetter
     *
     * @param string $applicationLetter
     * @return void
     */
    public function setApplicationLetter($applicationLetter)
    {
        $this->applicationLetter = $applicationLetter;
    }

    /**
     * Returns the documents
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference> $documents
     */
    public function getDocuments()
    {
        return $this->documents;
    }

    /**
     * Sets the images
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference> $documents
     * @return void
     */
    public function setDocuments(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $documents)
    {
        $this->documents = $documents;
    }

    /**
     * Adds an document
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $document
     * @return void
     */
    public function addDocument(\TYPO3\CMS\Extbase\Domain\Model\FileReference $document)
    {
        $this->documents->attach($document);
    }

    /**
     * Removes an document
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $documentToRemove The Document to be removed
     * @return void
     */
    public function removeDocument(\TYPO3\CMS\Extbase\Domain\Model\FileReference $documentToRemove)
    {
        $this->documents->detach($documentToRemove);
    }

    /**
     * Returns the curriculumVitae
     *
     * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference $curriculumVitae
     */
    public function getCurriculumVitae()
    {
        return $this->curriculumVitae;
    }

    /**
     * Sets the curriculumVitae
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $curriculumVitae
     * @return void
     */
    public function setCurriculumVitae(\TYPO3\CMS\Extbase\Domain\Model\FileReference $curriculumVitae = null)
    {
        $this->curriculumVitae = $curriculumVitae;
    }

    /**
     * Returns the jobReferences
     *
     * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference $jobReferences
     */
    public function getJobReferences()
    {
        return $this->jobReferences;
    }

    /**
     * Sets the jobReferences
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $jobReferences
     * @return void
     */
    public function setJobReferences(\TYPO3\CMS\Extbase\Domain\Model\FileReference $jobReferences = null)
    {
        $this->jobReferences = $jobReferences;
    }

    /**
     * Returns the diplomas
     *
     * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference $diplomas
     */
    public function getDiplomas()
    {
        return $this->diplomas;
    }

    /**
     * Sets the diplomas
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $diplomas
     * @return void
     */
    public function setDiplomas(\TYPO3\CMS\Extbase\Domain\Model\FileReference $diplomas = null)
    {
        $this->diplomas = $diplomas;
    }

    /**
     * Returns the file1
     *
     * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference $file1
     */
    public function getFile1()
    {
        return $this->file1;
    }

    /**
     * Sets the file1
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $file1
     * @return void
     */
    public function setFile1(\TYPO3\CMS\Extbase\Domain\Model\FileReference $file1 = null)
    {
        $this->file1 = $file1;
    }

    /**
     * Returns the file2
     *
     * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference $file2
     */
    public function getFile2()
    {
        return $this->file2;
    }

    /**
     * Sets the file2
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $file2
     * @return void
     */
    public function setFile2(\TYPO3\CMS\Extbase\Domain\Model\FileReference $file2 = null)
    {
        $this->file2 = $file2;
    }

    /**
     * Returns the file3
     *
     * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference $file3
     */
    public function getFile3()
    {
        return $this->file3;
    }

    /**
     * Sets the file3
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $file3
     * @return void
     */
    public function setFile3(\TYPO3\CMS\Extbase\Domain\Model\FileReference $file3 = null)
    {
        $this->file3 = $file3;
    }

    /**
     * Returns the file4
     *
     * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference $file4
     */
    public function getFile4()
    {
        return $this->file4;
    }

    /**
     * Sets the file4
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $file4
     * @return void
     */
    public function setFile4(\TYPO3\CMS\Extbase\Domain\Model\FileReference $file4 = null)
    {
        $this->file4 = $file4;
    }

    /**
     * Returns the applicationLetterFile
     *
     * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference $applicationLetterFile
     */
    public function getApplicationLetterFile()
    {
        return $this->applicationLetterFile;
    }

    /**
     * Sets the applicationLetterFile
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $applicationLetterFile
     * @return void
     */
    public function setApplicationLetterFile(\TYPO3\CMS\Extbase\Domain\Model\FileReference $applicationLetterFile = null)
    {
        $this->applicationLetterFile = $applicationLetterFile;
    }

    /**
     * Returns the position
     *
     * @return \Ig\IgJobs\Domain\Model\Position $position
     */
    public function getPosition()
    {
        return $this->position;
    }

    /**
     * Sets the position
     *
     * @param \Ig\IgJobs\Domain\Model\Position $position
     * @return void
     */
    public function setPosition(\Ig\IgJobs\Domain\Model\Position $position)
    {
        $this->position = $position;
    }

    /**
     * Returns the captchaResponse
     *
     * @return string $captchaResponse
     */
    public function getCaptchaResponse(){
        return $this->captchaResponse;
    }

    /**
     * Sets the captchaResponse
     *
     * @param string $captchaResponse
     * @return void
     */
    public function setCaptchaResponse($captchaResponse){
        $this->captchaResponse = $captchaResponse;
    }

    /**
     * Get the value of attention
     *
     * @return \Ig\IgJobs\Domain\Model\Attention
     */
    public function getAttention()
    {
        return $this->attention;
    }

    /**
     * Set the value of attention
     *
     * @param \Ig\IgJobs\Domain\Model\Attention $attention
     *
     * @return self
     */
    public function setAttention(\Ig\IgJobs\Domain\Model\Attention $attention = null)
    {
        $this->attention = $attention;

        return $this;
    }


    /**
     * Get the value of attentionOther
     *
     * @return string
     */
    public function getAttentionOther()
    {
        return $this->attentionOther;
    }

    /**
     * Set the value of attentionOther
     *
     * @param string $attentionOther
     *
     * @return self
     */
    public function setAttentionOther($attentionOther)
    {
        $this->attentionOther = $attentionOther;

        return $this;
    }

}
