<?php
namespace Ig\IgJobs\Domain\Model;

/***
 *
 * This file is part of the "SBK Job Database" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2018
 *
 ***/

/**
 * Category
 */
class Category extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * parent
     *
     * @var \Ig\IgJobs\Domain\Model\Category
     */
    protected $parent = null;

    /**
     * Returns the name
     *
     * @return string $name
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     * @return void
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * Returns the parent
     *
     * @return \Ig\IgJobs\Domain\Model\Category $parent
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Sets the parent
     *
     * @param \Ig\IgJobs\Domain\Model\Category $parent
     * @return void
     */
    public function setParent(\Ig\IgJobs\Domain\Model\Category $parent)
    {
        $this->parent = $parent;
    }
}
