<?php
namespace Ig\IgJobs\Domain\Model;

/***
 *
 * This file is part of the "SBK Job Database" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2018
 *
 ***/

/**
 * Position
 */
class Position extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * isTopPosition
     *
     * @var bool
     */
    protected $isTopPosition = false;

    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * description
     *
     * @var string
     */
    protected $subtitle = '';

    /**
     * positionNo
     *
     * @var string
     */
    protected $positionNo = '';

    /**
     * levelOfEmployment
     *
     * @var string
     */
    protected $levelOfEmployment = '';

    /**
     * levelOfEmploymentFrom
     *
     * @var int
     */
    protected $levelOfEmploymentFrom = 0;

    /**
     * levelOfEmploymentTo
     *
     * @var int
     */
    protected $levelOfEmploymentTo = 0;

    /**
     * region
     *
     * @var string
     */
    protected $region = '';

    /**
     * externalLink
     *
     * @var string
     */
    protected $externalLink = '';

    /**
     * jobStart
     *
     * @var string
     */
    protected $jobStart = '';

    /**
     * description
     *
     * @var string
     */
    protected $description = '';

    /**
     * committment
     *
     * @var string
     */
    protected $committment = '';

    /**
     * tasks
     *
     * @var string
     */
    protected $tasks = '';

    /**
     * requirements
     *
     * @var string
     */
    protected $requirements = '';

    /**
     * offer
     *
     * @var string
     */
    protected $offer = '';

    /**
     * contactPerson
     *
     * @var string
     */
    protected $contactPerson = '';

    /**
     * applicationText
     *
     * @var bool
     */
    protected $applicationText = false;

    /**
     * startdate
     *
     * @var \DateTime
     */
    protected $startdate = null;

    /**
     * enddate
     *
     * @var \DateTime
     */
    protected $enddate = null;

    /**
     * image
     *
     * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $image = null;

    /**
     * video
     *
     * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $video = null;

    /**
     * pdf
     *
     * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $pdf = null;

    /**
     * employment
     *
     * @var \Ig\IgJobs\Domain\Model\Employment
     */
    protected $employment = null;

    /**
     * location
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgJobs\Domain\Model\Location>
     */
    protected $location = null;

    /**
     * categories
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgJobs\Domain\Model\Category>
     */
    protected $categories = null;

    /**
     * categories
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgJobs\Domain\Model\Tag>
     */
    protected $tags = null;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     *
     * @return void
     */
    protected function initStorageObjects()
    {
        $this->location = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->categories = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }

    /**
     * Returns the title
     *
     * @return string $title
     */
    public function getTitle()
    {
        return $this->title;
    }

    public function getFullTitle()
    {
        $fullTitle = '';
        if($this->getPositionNo()) {
            $fullTitle = $this->getPositionNo() . ' - ';
        }

        $fullTitle .= trim($this->getTitle());

        return $fullTitle;
    }

    /**
     * Sets the title
     *
     * @param string $title
     * @return void
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * Returns the positionNo
     *
     * @return string $positionNo
     */
    public function getPositionNo()
    {
        return $this->positionNo;
    }

    /**
     * Sets the positionNo
     *
     * @param string $positionNo
     * @return void
     */
    public function setPositionNo($positionNo)
    {
        $this->positionNo = $positionNo;
    }

    /**
     * Returns the levelOfEmployment
     *
     * @return string $levelOfEmployment
     */
    public function getLevelOfEmployment()
    {
        return $this->levelOfEmployment;
    }

    /**
     * Sets the levelOfEmployment
     *
     * @param string $levelOfEmployment
     * @return void
     */
    public function setLevelOfEmployment($levelOfEmployment)
    {
        $this->levelOfEmployment = $levelOfEmployment;
    }

    /**
     * Returns the region
     *
     * @return string $region
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * Sets the region
     *
     * @param string $region
     * @return void
     */
    public function setRegion($region)
    {
        $this->region = $region;
    }

    /**
     * Returns the description
     *
     * @return string $description
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Returns the trimmed description
     *
     * @return string $description
     */
    public function getDescriptionTrimmed()
    {
        return trim($this->getDescription());
    }

    /**
     * Sets the description
     *
     * @param string $description
     * @return void
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    /**
     * Returns the applicationText
     *
     * @return bool $applicationText
     */
    public function getApplicationText()
    {
        return $this->applicationText;
    }

    /**
     * Sets the applicationText
     *
     * @param bool $applicationText
     * @return void
     */
    public function setApplicationText($applicationText)
    {
        $this->applicationText = $applicationText;
    }

    /**
     * Returns the boolean state of applicationText
     *
     * @return bool
     */
    public function isApplicationText()
    {
        return $this->applicationText;
    }

    /**
     * Returns the startdate
     *
     * @return \DateTime $startdate
     */
    public function getStartdate()
    {
        return $this->startdate;
    }

    /**
     * Sets the startdate
     *
     * @param \DateTime $startdate
     * @return void
     */
    public function setStartdate(\DateTime $startdate)
    {
        $this->startdate = $startdate;
    }

    /**
     * Returns the enddate
     *
     * @return \DateTime $enddate
     */
    public function getEnddate()
    {
        return $this->enddate;
    }

    /**
     * Sets the enddate
     *
     * @param \DateTime $enddate
     * @return void
     */
    public function setEnddate(\DateTime $enddate)
    {
        $this->enddate = $enddate;
    }

    /**
     * Returns the pdf
     *
     * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference $pdf
     */
    public function getPdf()
    {
        return $this->pdf;
    }

    /**
     * Sets the pdf
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $pdf
     * @return void
     */
    public function setPdf(\TYPO3\CMS\Extbase\Domain\Model\FileReference $pdf)
    {
        $this->pdf = $pdf;
    }

    /**
     * Returns the employment
     *
     * @return \Ig\IgJobs\Domain\Model\Employment $employment
     */
    public function getEmployment()
    {
        return $this->employment;
    }

    /**
     * Sets the employment
     *
     * @param \Ig\IgJobs\Domain\Model\Employment $employment
     * @return void
     */
    public function setEmployment(\Ig\IgJobs\Domain\Model\Employment $employment)
    {
        $this->employment = $employment;
    }

    /**
     * Adds a Category
     *
     * @param \Ig\IgJobs\Domain\Model\Category $category
     * @return void
     */
    public function addCategory(\Ig\IgJobs\Domain\Model\Category $category)
    {
        $this->categories->attach($category);
    }

    /**
     * Removes a Category
     *
     * @param \Ig\IgJobs\Domain\Model\Category $categoryToRemove The Category to be removed
     * @return void
     */
    public function removeCategory(\Ig\IgJobs\Domain\Model\Category $categoryToRemove)
    {
        $this->categories->detach($categoryToRemove);
    }

    /**
     * Returns the categories
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgJobs\Domain\Model\Category> $categories
     */
    public function getCategories()
    {
        return $this->categories;
    }

    /**
     * Sets the categories
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgJobs\Domain\Model\Category> $categories
     * @return void
     */
    public function setCategories(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $categories)
    {
        $this->categories = $categories;
    }

    /**
     * Adds a Tag
     *
     * @param \Ig\IgJobs\Domain\Model\Tag $tag
     * @return void
     */
    public function addTag(\Ig\IgJobs\Domain\Model\Tag $tag)
    {
        $this->tags->attach($tag);
    }

    /**
     * Removes a Tag
     *
     * @param \Ig\IgJobs\Domain\Model\Tag $tagToRemove The Category to be removed
     * @return void
     */
    public function removeTag(\Ig\IgJobs\Domain\Model\Tag $tagToRemove)
    {
        $this->tags->detach($tagToRemove);
    }

    /**
     * Returns the tags
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgJobs\Domain\Model\Tag> $tags
     */
    public function getTags()
    {
        return $this->tags;
    }

    /**
     * Sets the tags
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgJobs\Domain\Model\Tag> $tags
     * @return void
     */
    public function setTags(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $tags)
    {
        $this->tags = $tags;
    }

    public function isOnline() {
        $now = new \DateTime();

        $startdate = $this->getStartdate();
        $enddate = $this->getEnddate();

        if($startdate && $enddate) {
            if($startdate <= $now && $enddate >= $now) {
                return true;
            }

            return false;
        }

        if($startdate && !$enddate) {
            if($startdate <= $now) {
                return true;
            }

            return false;
        }

        if($enddate && !$startdate) {
            if($enddate >= $now) {
                return true;
            }

            return false;
        }

        if(!$startdate && !$enddate) {
            return true;
        }

        return false;
    }

    /**
     * Get the value of externalLink
     *
     * @return string
     */
    public function getExternalLink()
    {
        return $this->externalLink;
    }

    /**
     * Set the value of externalLink
     *
     * @param string $externalLink
     *
     * @return self
     */
    public function setExternalLink($externalLink)
    {
        $this->externalLink = $externalLink;

        return $this;
    }


    /**
     * Get the value of levelOfEmploymentFrom
     *
     * @return int
     */
    public function getLevelOfEmploymentFrom()
    {
        return $this->levelOfEmploymentFrom;
    }

    /**
     * Set the value of levelOfEmploymentFrom
     *
     * @param int $levelOfEmploymentFrom
     *
     * @return self
     */
    public function setLevelOfEmploymentFrom($levelOfEmploymentFrom)
    {
        $this->levelOfEmploymentFrom = $levelOfEmploymentFrom;

        return $this;
    }

    /**
     * Get the value of levelOfEmploymentTo
     *
     * @return int
     */
    public function getLevelOfEmploymentTo()
    {
        return $this->levelOfEmploymentTo;
    }

    /**
     * Set the value of levelOfEmploymentTo
     *
     * @param int $levelOfEmploymentTo
     *
     * @return self
     */
    public function setLevelOfEmploymentTo($levelOfEmploymentTo)
    {
        $this->levelOfEmploymentTo = $levelOfEmploymentTo;

        return $this;
    }

    public function getLevelOfEmploymentCombined()
    {
        $levelOfEmploymentFrom = $this->getLevelOfEmploymentFrom();
        $levelOfEmploymentTo = $this->getLevelOfEmploymentTo();
        $levelOfEmploymentCombined = '';

        if($levelOfEmploymentFrom) {
            $levelOfEmploymentCombined .= $levelOfEmploymentFrom;

            if(!$levelOfEmploymentTo || $levelOfEmploymentTo == $levelOfEmploymentFrom) {
                $levelOfEmploymentCombined .= '%';
            }
        }

        if($levelOfEmploymentTo && $levelOfEmploymentTo != $levelOfEmploymentFrom) {
            if($levelOfEmploymentFrom) {
                $levelOfEmploymentCombined .= '-';
            }

            $levelOfEmploymentCombined .= $levelOfEmploymentTo . '%';
        }

        return $levelOfEmploymentCombined;
    }


    /**
     * Get the value of description
     *
     * @return string
     */
    public function getSubtitle()
    {
        return $this->subtitle;
    }

    /**
     * Set the value of description
     *
     * @param string $subtitle
     *
     * @return self
     */
    public function setSubtitle($subtitle)
    {
        $this->subtitle = $subtitle;

        return $this;
    }


    /**
     * Get the value of isTopPosition
     *
     * @return bool
     */
    public function getIsTopPosition()
    {
        return $this->isTopPosition;
    }

    /**
     * Set the value of isTopPosition
     *
     * @param bool $isTopPosition
     *
     * @return self
     */
    public function setIsTopPosition($isTopPosition)
    {
        $this->isTopPosition = $isTopPosition;

        return $this;
    }

    /**
     * Adds a Location
     *
     * @param \Ig\IgJobs\Domain\Model\Location $location
     * @return void
     */
    public function addLocation(\Ig\IgJobs\Domain\Model\Location $location)
    {
        $this->location->attach($location);
    }

    /**
     * Removes a Location
     *
     * @param \Ig\IgJobs\Domain\Model\Location $locationToRemove The Location to be removed
     * @return void
     */
    public function removeLocation(\Ig\IgJobs\Domain\Model\Location $locationToRemove)
    {
        $this->location->detach($locationToRemove);
    }

    /**
     * Removes all Location
     *
     * @return void
     */
    public function removeAllLocation()
    {
        foreach ($this->getLocations() as $loc) {
            $this->location->detach($loc);
        }
    }

    /**
     * Returns the Locations
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgJobs\Domain\Model\Location> $location
     */
    public function getLocations()
    {
        return $this->location;
    }
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * Sets the Locations
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgJobs\Domain\Model\Location> $locations
     * @return void
     */
    public function setLocations(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $locations)
    {
        $this->location = $locations;
    }


    /**
     * Get the value of image
     *
     * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * Set the value of image
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $image
     *
     * @return self
     */
    public function setImage(\TYPO3\CMS\Extbase\Domain\Model\FileReference $image)
    {
        $this->image = $image;

        return $this;
    }

    /**
     * Get the value of video
     *
     * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference
     */
    public function getVideo()
    {
        return $this->video;
    }

    /**
     * Set the value of video
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $video
     *
     * @return self
     */
    public function setVideo(\TYPO3\CMS\Extbase\Domain\Model\FileReference $video)
    {
        $this->video = $video;

        return $this;
    }


    /**
     * Get the value of jobStart
     *
     * @return string
     */
    public function getJobStart()
    {
        return $this->jobStart;
    }

    /**
     * Set the value of jobStart
     *
     * @param string $jobStart
     *
     * @return self
     */
    public function setJobStart($jobStart)
    {
        $this->jobStart = $jobStart;

        return $this;
    }

    /**
     * Get the value of requirements
     *
     * @return string
     */
    public function getRequirements()
    {
        return $this->requirements;
    }

    /**
     * Set the value of requirements
     *
     * @param string $requirements
     *
     * @return self
     */
    public function setRequirements($requirements)
    {
        $this->requirements = $requirements;

        return $this;
    }

    /**
     * Get the value of offer
     *
     * @return string
     */
    public function getOffer()
    {
        return $this->offer;
    }

    /**
     * Set the value of offer
     *
     * @param string $offer
     *
     * @return self
     */
    public function setOffer($offer)
    {
        $this->offer = $offer;

        return $this;
    }


    /**
     * Get the value of contactPerson
     *
     * @return string
     */
    public function getContactPerson()
    {
        return $this->contactPerson;
    }

    /**
     * Set the value of contactPerson
     *
     * @param string $contactPerson
     *
     * @return void
     */
    public function setContactPerson($contactPerson)
    {
        $this->contactPerson = $contactPerson;
    }


    /**
     * Get the value of committment
     */
    public function getCommittment(): string
    {
        return $this->committment;
    }

    /**
     * Set the value of committment
     */
    public function setCommittment(string $committment): void
    {
        $this->committment = $committment;
    }

    /**
     * Get the value of tasks
     */
    public function getTasks(): string
    {
        return $this->tasks;
    }

    /**
     * Set the value of tasks
     */
    public function setTasks(string $tasks): void
    {
        $this->tasks = $tasks;
    }

    public function getCompleteTitle()
    {
        $title = $this->getTitle();

        $levelOfEmployment = $this->getLevelOfEmploymentCombined();

        if(!$levelOfEmployment) {
            $levelOfEmployment = $this->getLevelOfEmployment();
        }

        if($levelOfEmployment) {
            $title .= ' (' . $levelOfEmployment . ')';
        }
        
        return $title;
    }
}
