<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application',
        'label' => 'last_name',
        'label_alt' => 'first_name',
        'label_alt_force' => true,
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'default_sortby' => 'crdate DESC',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'gender,first_name,last_name,address,address_additional,zip_city,phone,mobile,email,message,birth_date,application_letter,curriculum_vitae,job_references,diplomas,file1,file2,file3,file4,application_letter_file,position',
        'iconfile' => 'EXT:ig_jobs/Resources/Public/Icons/tx_igjobs_domain_model_application.gif'
    ],
    'interface' => [
        'showRecordFieldList' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, gender, first_name, last_name, address, address_additional, zip_city, phone, mobile, email, message, birth_date, application_letter, documents, curriculum_vitae, job_references, diplomas, file1, file2, application_letter_file, position',
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, gender, first_name, last_name, address, address_additional, zip_city, phone, mobile, email, message, birth_date, application_letter, documents, curriculum_vitae, job_references, diplomas, file1, file2, file3, file4, application_letter_file, position, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'special' => 'languages',
                'items' => [
                    [
                        'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.allLanguages',
                        -1,
                        'flags-multiple'
                    ]
                ],
                'default' => 0,
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['', 0],
                ],
                'foreign_table' => 'tx_igjobs_domain_model_application',
                'foreign_table_where' => 'AND tx_igjobs_domain_model_application.pid=###CURRENT_PID### AND tx_igjobs_domain_model_application.sys_language_uid IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],
        'hidden' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.hidden',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'default' => 0,
                'items' => [
                    [
                        0 => '',
                        1 => '',
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],
        'endtime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038),
                ],
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],

        'gender' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.gender',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['', 0],
                    ['Frau', 1],
                    ['Herr', 2],
                ],
                'size' => 1,
                'maxitems' => 1,
                'eval' => ''
            ],
        ],
        'first_name' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.first_name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'last_name' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.last_name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'address' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.address',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'address_additional' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.address_additional',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'zip_city' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.zip_city',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'phone' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.phone',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'mobile' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.mobile',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'email' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.email',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'message' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.message',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim'
            ]
        ],
        'birth_date' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.birth_date',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'application_letter' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.application_letter',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim'
            ]
        ],
        'documents' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.documents',
            'config' => [
                'type' => 'file',
                'foreign_match_fields' => [
                    'tablenames' => 'tx_igjobs_domain_model_application',
                ],
                'maxitems' => 9999,
                'allowed' => 'pdf,docx,odt',
            ]
        ],
        'curriculum_vitae' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.curriculum_vitae',
            'config' => [
                'type' => 'file',
                'foreign_match_fields' => [
                    'tablenames' => 'tx_igjobs_domain_model_application',
                ],
                'maxitems' => 1,
                'allowed' => 'pdf,docx,odt',
            ]
        ],
        'job_references' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.job_references',
            'config' => [
                'type' => 'file',
                'foreign_match_fields' => [
                    'tablenames' => 'tx_igjobs_domain_model_application',
                ],
                'maxitems' => 9999,
                'allowed' => 'pdf,docx,odt',
            ]
        ],
        'diplomas' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.diplomas',
            'config' => [
                'type' => 'file',
                'foreign_match_fields' => [
                    'tablenames' => 'tx_igjobs_domain_model_application',
                ],
                'maxitems' => 9999,
                'allowed' => 'pdf,docx,odt',
            ]
        ],
        'file1' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.file1',
            'config' => [
                'type' => 'file',
                'foreign_match_fields' => [
                    'tablenames' => 'tx_igjobs_domain_model_application',
                ],
                'maxitems' => 9999,
                'allowed' => 'pdf,docx,odt',
            ]
        ],
        'file2' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.file2',
            'config' => [
                'type' => 'file',
                'foreign_match_fields' => [
                    'tablenames' => 'tx_igjobs_domain_model_application',
                ],
                'maxitems' => 1,
                'allowed' => 'pdf,docx,odt',
            ]
        ],
        'file3' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.file3',
            'config' => [
                'type' => 'file',
                'foreign_match_fields' => [
                    'tablenames' => 'tx_igjobs_domain_model_application',
                ],
                'maxitems' => 1,
                'allowed' => 'pdf,docx,odt',
            ]
        ],
        'file4' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.file4',
            'config' => [
                'type' => 'file',
                'foreign_match_fields' => [
                    'tablenames' => 'tx_igjobs_domain_model_application',
                ],
                'maxitems' => 1,
                'allowed' => 'pdf,docx,odt',
            ]
        ],
        'application_letter_file' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.application_letter_file',
            'config' => [
                'type' => 'file',
                'foreign_match_fields' => [
                    'tablenames' => 'tx_igjobs_domain_model_application',
                ],
                'maxitems' => 1,
                'allowed' => 'pdf,docx,odt',
            ]
        ],
        'position' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_application.position',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igjobs_domain_model_position',
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],

    ],
];
