<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position',
        'label' => 'position_no',
        'label_alt' => 'title',
        'label_alt_force' => true,
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'default_sortby' => 'tstamp DESC',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'sortby' => 'sorting',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'title,subtitle,position_no,level_of_employment,region,external_link,description,committment,tasks,application_text,startdate,enddate,pdf,employment,categories',
        'iconfile' => 'EXT:ig_jobs/Resources/Public/Icons/tx_igjobs_domain_model_position.gif'
    ],
    'interface' => [
        'showRecordFieldList' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, is_top_position, title, path_segment, subtitle, position_no, level_of_employment, level_of_employment_from, level_of_employment_to, region, location, external_link, job_start, description, committment, tasks, requirements, offer, contact_person, application_text, startdate, enddate, image, video, pdf, employment, categories',
    ],
    'types' => [
        '1' => ['showitem' => 'hidden, is_top_position, title, path_segment, subtitle, position_no, external_link, description, job_start, committment, tasks, requirements, offer, contact_person, application_text, --div--;Anstellung, level_of_employment, level_of_employment_from, level_of_employment_to, employment, --div--;Aufschalt-Zeitraum, startdate, enddate, --div--;Tags, tags, --div--;Standort, region, location, --div--;Kategorien, categories, --div--;Dateien, image, video, pdf, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access, starttime, endtime, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.language,sys_language_uid, l10n_parent, l10n_diffsource'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'special' => 'languages',
                'items' => [
                    [
                        'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.allLanguages',
                        -1,
                        'flags-multiple'
                    ]
                ],
                'default' => 0,
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['', 0],
                ],
                'foreign_table' => 'tx_igjobs_domain_model_position',
                'foreign_table_where' => 'AND tx_igjobs_domain_model_position.pid=###CURRENT_PID### AND tx_igjobs_domain_model_position.sys_language_uid IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],
        'hidden' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.hidden',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'default' => 0,
                'items' => [
                    [
                        0 => '',
                        1 => '',
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],
        'endtime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038),
                ],
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],

        'is_top_position' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.is_top_position',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'default' => 0,
                'items' => [
                    [
                        0 => '',
                        1 => '',
                    ]
                ],
            ],
        ],
        'title' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.title',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'subtitle' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.subtitle',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'position_no' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.position_no',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'level_of_employment' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.level_of_employment',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'level_of_employment_from' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.level_of_employment_from',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'level_of_employment_to' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.level_of_employment_to',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'region' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.region',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'external_link' => [
            'exclude' => true,
            'label' => 'Externer Link',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputLink',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'job_start' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.job_start',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
        ],
        'description' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.description',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
        ],
        'committment' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.committment',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
        ],
        'tasks' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.tasks',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
        ],
        'requirements' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.requirements',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
        ],
        'offer' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.offer',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
        ],
        'contact_person' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.contact_person',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
        ],
        'application_text' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.application_text',
            'config' => [
                'type' => 'check',
                'default' => 1,
            ]
        ],
        'startdate' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.startdate',
            'config' => [
                'dbType' => 'date',
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'size' => 7,
                'eval' => 'date,null',
                'default' => null,
            ],
        ],
        'enddate' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.enddate',
            'config' => [
                'dbType' => 'date',
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'size' => 7,
                'eval' => 'date,null',
                'default' => null,
            ],
        ],
        'image' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.image',
            'config' => [
                'type' => 'file',
                'foreign_match_fields' => [
                    'tablenames' => 'tx_igjobs_domain_model_position',
                ],
                'maxitems' => 1,
                'allowed' => 'common-image-types',
            ]
        ],
        'video' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.video',
            'config' => [
                'type' => 'file',
                'foreign_match_fields' => [
                    'tablenames' => 'tx_igjobs_domain_model_position',
                ],
                'maxitems' => 1,
                'allowed' => 'mp4,mov',
            ]
        ],
        'pdf' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.pdf',
            'config' => [
                'type' => 'file',
                'foreign_match_fields' => [
                    'tablenames' => 'tx_igjobs_domain_model_position',
                ],
                'maxitems' => 1,
                'allowed' => 'pdf',
            ]
        ],
        'employment' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.employment',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igjobs_domain_model_employment',
                'items' => [
                    ['', 0],
                ],
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
        'location' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.location',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igjobs_domain_model_location',
                'MM' => 'tx_igjobs_position_location_mm',
                // 'items' => [
                //     ['', 0],
                // ],
                // 'minitems' => 0,
                // 'maxitems' => 1,
            ],
        ],
        'categories' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.categories',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igjobs_domain_model_category',
                'MM' => 'tx_igjobs_position_category_mm',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'wizards' => [
                    '_PADDING' => 1,
                    '_VERTICAL' => 1,
                    'edit' => [
                        'module' => [
                            'name' => 'wizard_edit',
                        ],
                        'type' => 'popup',
                        'title' => 'Edit', // todo define label: LLL:EXT:.../Resources/Private/Language/locallang_tca.xlf:wizard.edit
                        'icon' => 'EXT:backend/Resources/Public/Images/FormFieldWizard/wizard_edit.gif',
                        'popup_onlyOpenIfSelected' => 1,
                        'JSopenParams' => 'height=350,width=580,status=0,menubar=0,scrollbars=1',
                    ],
                    'add' => [
                        'module' => [
                            'name' => 'wizard_add',
                        ],
                        'type' => 'script',
                        'title' => 'Create new', // todo define label: LLL:EXT:.../Resources/Private/Language/locallang_tca.xlf:wizard.add
                        'icon' => 'EXT:backend/Resources/Public/Images/FormFieldWizard/wizard_add.gif',
                        'params' => [
                            'table' => 'tx_igjobs_domain_model_category',
                            'pid' => '###CURRENT_PID###',
                            'setValue' => 'prepend'
                        ],
                    ],
                ],
            ],

        ],
        'tags' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_jobs/Resources/Private/Language/locallang_db.xlf:tx_igjobs_domain_model_position.tags',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igjobs_domain_model_tag',
                'MM' => 'tx_igjobs_position_tag_mm',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'wizards' => [
                    '_PADDING' => 1,
                    '_VERTICAL' => 1,
                    'edit' => [
                        'module' => [
                            'name' => 'wizard_edit',
                        ],
                        'type' => 'popup',
                        'title' => 'Edit', // todo define label: LLL:EXT:.../Resources/Private/Language/locallang_tca.xlf:wizard.edit
                        'icon' => 'EXT:backend/Resources/Public/Images/FormFieldWizard/wizard_edit.gif',
                        'popup_onlyOpenIfSelected' => 1,
                        'JSopenParams' => 'height=350,width=580,status=0,menubar=0,scrollbars=1',
                    ],
                    'add' => [
                        'module' => [
                            'name' => 'wizard_add',
                        ],
                        'type' => 'script',
                        'title' => 'Create new', // todo define label: LLL:EXT:.../Resources/Private/Language/locallang_tca.xlf:wizard.add
                        'icon' => 'EXT:backend/Resources/Public/Images/FormFieldWizard/wizard_add.gif',
                        'params' => [
                            'table' => 'tx_igjobs_domain_model_category',
                            'pid' => '###CURRENT_PID###',
                            'setValue' => 'prepend'
                        ],
                    ],
                ],
            ],

        ],

        'path_segment' => [
            'exclude' => true,
            'label' => 'Pfadsegment',
            'config' => [
                'type' => 'slug',
                'size' => 50,
                'eval' => 'uniqueInPid',
                'prependSlash' => false,
                'fallbackCharacter' => '-',
                'default' => '',
                'generatorOptions' => [
                    'fields' => ['title'],
                    'fieldSeparator' => '-',
                    'prefixParentPageSlug' => true,
                    'replacements' => [
                        '/' => '',
                    ],
                ],
            ],
        ],

    ],
];
