// Validation Kursanmeldung
if(document.querySelectorAll('.tx-ig-jobs .applicationForm').length > 0) {
    // Switch tab in registration form
    function switchTab(tab) {
        document.querySelectorAll('.tx-ig-jobs .applicationForm .tabMenu .tabLink').forEach(function(tabLink) {
            tabLink.classList.remove('active');
        });
        // Add 'active' class to the tab link
        document.querySelector('.tx-ig-jobs .applicationForm .tabMenu .tabLink.' + tab + '-link').classList.add('active');

        // Remove 'show' class from all tabs
        document.querySelectorAll('.tx-ig-jobs .applicationForm .tab').forEach(function(element) {
            element.classList.remove('show');
        });

        // Add 'show' class to the selected tab
        document.querySelector('.tx-ig-jobs .applicationForm .' + tab).classList.add('show');
    }

    // Switch to tab with first error in registration form
    function switchToErrorTab() {
        switchTab(document.querySelector('.tx-ig-jobs .applicationForm .error').closest('.tab').dataset.tab);
    }

    // Validation of form elements before tab switch and submit
    function validateBeforeTabSwitch() {
        var emailRegex = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
	    let emailField = document.getElementById('application-email');
        let isFormValid = true;

        document.querySelectorAll('.tx-ig-jobs .applicationForm .tab1 .registration-validate').forEach((field, i) => {
            if(field.value != '') {
                field.classList.remove('error');
            } else {
                field.classList.add('error');
                isFormValid = false;
            }
        });

        // field should be type email and test should be done in the loop above
        emailField.classList.remove('error');
        if(emailField.value == '' || !emailRegex.test(emailField.value)) {
            emailField.classList.add('error');
            isFormValid = false;
        }

        return isFormValid;
    }
    
    // Validation on submit of registration form
    // Handle validation on tab switch
    document.querySelectorAll('.tx-ig-jobs .applicationForm .tabLink').forEach(function(element) {
        element.addEventListener('click', function(e) {
            e.preventDefault();
            if (validateBeforeTabSwitch()) {
                switchTab(element.dataset.tab);
            } else {
                switchToErrorTab();
            }
        });
    });

    // Jump to tab with first error on load if errors are in the registration form
    if(document.querySelectorAll('.tx-ig-jobs .applicationForm .error').length > 0) {
        switchToErrorTab();
    }
}

function onIgJobsCaptchaSubmit() {
    var tab = document.querySelector('.tx-ig-jobs .applicationForm .tab2');
    if (!tab) {
        tab = document.querySelector('.tx-ig-jobs .applicationForm .tab1');
    }

    if (!tab.classList.contains('show')) {
        return;
    }

    var isFormValid = validateBeforeTabSwitch();

    document.querySelectorAll('.fileupload.required').forEach(function(element) {
        var filenameElement = element.querySelector('.dp-filename');
        console.log(filenameElement);
        if (!filenameElement || filenameElement.textContent.trim() === '') {
            element.classList.add('error');
            isFormValid = false;
        } else {
            element.classList.remove('error');
        }
    });

    if(!isFormValid) {
        switchToErrorTab();
        return;
    }
    if (!grecaptcha || !grecaptcha.getResponse()) {
        grecaptcha.execute();
        return;
    }
    document.querySelector('.tx-ig-jobs .applicationForm').submit();
}

function changeNoUiSliders() {
    var noUiSliderElements = document.querySelectorAll('.igjobs-searchform .dp-slider-range-slider');
    noUiSliderElements?.forEach(function(element) {
        element.noUiSlider.updateOptions({
            margin: 10,
            pips: {
                mode: 'steps',
                density: 10,
                format: wNumb({
                    decimals: 0,
                    suffix: '%'
                })
            }
        });
        element.noUiSlider.on('set', function(values, handle, unencoded, tap, positions, noUiSlider) {
            setTimeout(function() {
                var form = document.querySelector('.igjobs-searchform form');
                var submitEvent = new Event('submit');
                form.dispatchEvent(submitEvent);
            }, 10);
        });
    });
}
changeNoUiSliders();


if(document.querySelectorAll('.igjobs-searchform .dp-select2').length) {
    document.querySelectorAll('.igjobs-searchform .dp-select2').forEach(function(select2) {
        // TODO: select2 needs jQuery
        $(select2).on('select2:close', function(e) {
            select2.closest('form').submit();
        })
    });
    window.addEventListener('resize', function(e) {
        document.querySelectorAll('.igjobs-searchform .select2 ').forEach(function(select2) {
            select2.style.width = '100%';
        });
    });
}

if(document.querySelectorAll('.igjobs-locations').length) {
    document.querySelectorAll('.igjobs-locations .igjobs-location a').forEach(function(link) {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            var location = link.dataset.location;

            if(location == 'all') {
                document.querySelector('#igjobs-location-hidden').value = '';
            } else {
                document.querySelector('#igjobs-location-hidden').value = location;
            }

            link.closest('form').submit();
        });
    });
}

if(document.querySelectorAll('#application-attention').length) {
    if (document.querySelector('#application-attention option:checked').dataset.showOtherField) {
        document.querySelector('.attention-other-field').classList.add('show');
        document.querySelector('.attention-other-field input[type="text"]').classList.add('registration-validate');
    }

    document.querySelector('#application-attention').addEventListener('change', function() {
        document.querySelector('.attention-other-field').classList.remove('show');
        document.querySelector('.attention-other-field input[type="text"]').classList.remove('registration-validate');

        if (document.querySelector('#application-attention option:checked').dataset.showOtherField) {
            document.querySelector('.attention-other-field').classList.add('show');
            document.querySelector('.attention-other-field input[type="text"]').classList.add('registration-validate');
        }
    });
}
