<?php
namespace Ig\IgJobs\Tests\Unit\Controller;

/**
 * Test case.
 *
 * @author Simon Häsler <sh@internetgalerie.ch>
 */
class ApplicationControllerTest extends \TYPO3\CMS\Core\Tests\UnitTestCase
{
    /**
     * @var \Ig\IgJobs\Controller\ApplicationController
     */
    protected $subject = null;

    protected function setUp()
    {
        parent::setUp();
        $this->subject = $this->getMockBuilder(\Ig\IgJobs\Controller\ApplicationController::class)
            ->setMethods(['redirect', 'forward', 'addFlashMessage'])
            ->disableOriginalConstructor()
            ->getMock();
    }

    protected function tearDown()
    {
        parent::tearDown();
    }

    /**
     * @test
     */
    public function createActionAddsTheGivenApplicationToApplicationRepository()
    {
        $application = new \Ig\IgJobs\Domain\Model\Application();

        $applicationRepository = $this->getMockBuilder(\Ig\IgJobs\Domain\Repository\ApplicationRepository::class)
            ->setMethods(['add'])
            ->disableOriginalConstructor()
            ->getMock();

        $applicationRepository->expects(self::once())->method('add')->with($application);
        $this->inject($this->subject, 'applicationRepository', $applicationRepository);

        $this->subject->createAction($application);
    }
}
