<?php
namespace Ig\IgJobs\Tests\Unit\Controller;

/**
 * Test case.
 *
 * @author Simon Häsler <sh@internetgalerie.ch>
 */
class EmploymentControllerTest extends \TYPO3\CMS\Core\Tests\UnitTestCase
{
    /**
     * @var \Ig\IgJobs\Controller\EmploymentController
     */
    protected $subject = null;

    protected function setUp()
    {
        parent::setUp();
        $this->subject = $this->getMockBuilder(\Ig\IgJobs\Controller\EmploymentController::class)
            ->setMethods(['redirect', 'forward', 'addFlashMessage'])
            ->disableOriginalConstructor()
            ->getMock();
    }

    protected function tearDown()
    {
        parent::tearDown();
    }

    /**
     * @test
     */
    public function listActionFetchesAllEmploymentsFromRepositoryAndAssignsThemToView()
    {

        $allEmployments = $this->getMockBuilder(\TYPO3\CMS\Extbase\Persistence\ObjectStorage::class)
            ->disableOriginalConstructor()
            ->getMock();

        $employmentRepository = $this->getMockBuilder(\Ig\IgJobs\Domain\Repository\EmploymentRepository::class)
            ->setMethods(['findAll'])
            ->disableOriginalConstructor()
            ->getMock();
        $employmentRepository->expects(self::once())->method('findAll')->will(self::returnValue($allEmployments));
        $this->inject($this->subject, 'employmentRepository', $employmentRepository);

        $view = $this->getMockBuilder(\TYPO3\CMS\Extbase\Mvc\View\ViewInterface::class)->getMock();
        $view->expects(self::once())->method('assign')->with('employments', $allEmployments);
        $this->inject($this->subject, 'view', $view);

        $this->subject->listAction();
    }

    /**
     * @test
     */
    public function createActionAddsTheGivenEmploymentToEmploymentRepository()
    {
        $employment = new \Ig\IgJobs\Domain\Model\Employment();

        $employmentRepository = $this->getMockBuilder(\Ig\IgJobs\Domain\Repository\EmploymentRepository::class)
            ->setMethods(['add'])
            ->disableOriginalConstructor()
            ->getMock();

        $employmentRepository->expects(self::once())->method('add')->with($employment);
        $this->inject($this->subject, 'employmentRepository', $employmentRepository);

        $this->subject->createAction($employment);
    }

    /**
     * @test
     */
    public function editActionAssignsTheGivenEmploymentToView()
    {
        $employment = new \Ig\IgJobs\Domain\Model\Employment();

        $view = $this->getMockBuilder(\TYPO3\CMS\Extbase\Mvc\View\ViewInterface::class)->getMock();
        $this->inject($this->subject, 'view', $view);
        $view->expects(self::once())->method('assign')->with('employment', $employment);

        $this->subject->editAction($employment);
    }

    /**
     * @test
     */
    public function updateActionUpdatesTheGivenEmploymentInEmploymentRepository()
    {
        $employment = new \Ig\IgJobs\Domain\Model\Employment();

        $employmentRepository = $this->getMockBuilder(\Ig\IgJobs\Domain\Repository\EmploymentRepository::class)
            ->setMethods(['update'])
            ->disableOriginalConstructor()
            ->getMock();

        $employmentRepository->expects(self::once())->method('update')->with($employment);
        $this->inject($this->subject, 'employmentRepository', $employmentRepository);

        $this->subject->updateAction($employment);
    }

    /**
     * @test
     */
    public function deleteActionRemovesTheGivenEmploymentFromEmploymentRepository()
    {
        $employment = new \Ig\IgJobs\Domain\Model\Employment();

        $employmentRepository = $this->getMockBuilder(\Ig\IgJobs\Domain\Repository\EmploymentRepository::class)
            ->setMethods(['remove'])
            ->disableOriginalConstructor()
            ->getMock();

        $employmentRepository->expects(self::once())->method('remove')->with($employment);
        $this->inject($this->subject, 'employmentRepository', $employmentRepository);

        $this->subject->deleteAction($employment);
    }
}
