<?php
namespace Ig\IgJobs\Tests\Unit\Controller;

/**
 * Test case.
 *
 * @author Simon Häsler <sh@internetgalerie.ch>
 */
class PositionControllerTest extends \TYPO3\CMS\Core\Tests\UnitTestCase
{
    /**
     * @var \Ig\IgJobs\Controller\PositionController
     */
    protected $subject = null;

    protected function setUp()
    {
        parent::setUp();
        $this->subject = $this->getMockBuilder(\Ig\IgJobs\Controller\PositionController::class)
            ->setMethods(['redirect', 'forward', 'addFlashMessage'])
            ->disableOriginalConstructor()
            ->getMock();
    }

    protected function tearDown()
    {
        parent::tearDown();
    }

    /**
     * @test
     */
    public function listActionFetchesAllPositionsFromRepositoryAndAssignsThemToView()
    {

        $allPositions = $this->getMockBuilder(\TYPO3\CMS\Extbase\Persistence\ObjectStorage::class)
            ->disableOriginalConstructor()
            ->getMock();

        $positionRepository = $this->getMockBuilder(\Ig\IgJobs\Domain\Repository\PositionRepository::class)
            ->setMethods(['findAll'])
            ->disableOriginalConstructor()
            ->getMock();
        $positionRepository->expects(self::once())->method('findAll')->will(self::returnValue($allPositions));
        $this->inject($this->subject, 'positionRepository', $positionRepository);

        $view = $this->getMockBuilder(\TYPO3\CMS\Extbase\Mvc\View\ViewInterface::class)->getMock();
        $view->expects(self::once())->method('assign')->with('positions', $allPositions);
        $this->inject($this->subject, 'view', $view);

        $this->subject->listAction();
    }

    /**
     * @test
     */
    public function showActionAssignsTheGivenPositionToView()
    {
        $position = new \Ig\IgJobs\Domain\Model\Position();

        $view = $this->getMockBuilder(\TYPO3\CMS\Extbase\Mvc\View\ViewInterface::class)->getMock();
        $this->inject($this->subject, 'view', $view);
        $view->expects(self::once())->method('assign')->with('position', $position);

        $this->subject->showAction($position);
    }

    /**
     * @test
     */
    public function createActionAddsTheGivenPositionToPositionRepository()
    {
        $position = new \Ig\IgJobs\Domain\Model\Position();

        $positionRepository = $this->getMockBuilder(\Ig\IgJobs\Domain\Repository\PositionRepository::class)
            ->setMethods(['add'])
            ->disableOriginalConstructor()
            ->getMock();

        $positionRepository->expects(self::once())->method('add')->with($position);
        $this->inject($this->subject, 'positionRepository', $positionRepository);

        $this->subject->createAction($position);
    }

    /**
     * @test
     */
    public function editActionAssignsTheGivenPositionToView()
    {
        $position = new \Ig\IgJobs\Domain\Model\Position();

        $view = $this->getMockBuilder(\TYPO3\CMS\Extbase\Mvc\View\ViewInterface::class)->getMock();
        $this->inject($this->subject, 'view', $view);
        $view->expects(self::once())->method('assign')->with('position', $position);

        $this->subject->editAction($position);
    }

    /**
     * @test
     */
    public function updateActionUpdatesTheGivenPositionInPositionRepository()
    {
        $position = new \Ig\IgJobs\Domain\Model\Position();

        $positionRepository = $this->getMockBuilder(\Ig\IgJobs\Domain\Repository\PositionRepository::class)
            ->setMethods(['update'])
            ->disableOriginalConstructor()
            ->getMock();

        $positionRepository->expects(self::once())->method('update')->with($position);
        $this->inject($this->subject, 'positionRepository', $positionRepository);

        $this->subject->updateAction($position);
    }

    /**
     * @test
     */
    public function deleteActionRemovesTheGivenPositionFromPositionRepository()
    {
        $position = new \Ig\IgJobs\Domain\Model\Position();

        $positionRepository = $this->getMockBuilder(\Ig\IgJobs\Domain\Repository\PositionRepository::class)
            ->setMethods(['remove'])
            ->disableOriginalConstructor()
            ->getMock();

        $positionRepository->expects(self::once())->method('remove')->with($position);
        $this->inject($this->subject, 'positionRepository', $positionRepository);

        $this->subject->deleteAction($position);
    }
}
