<?php
namespace Ig\IgJobs\Tests\Unit\Domain\Model;

/**
 * Test case.
 *
 * @author Simon Häsler <sh@internetgalerie.ch>
 */
class ApplicationTest extends \TYPO3\CMS\Core\Tests\UnitTestCase
{
    /**
     * @var \Ig\IgJobs\Domain\Model\Application
     */
    protected $subject = null;

    protected function setUp()
    {
        parent::setUp();
        $this->subject = new \Ig\IgJobs\Domain\Model\Application();
    }

    protected function tearDown()
    {
        parent::tearDown();
    }

    /**
     * @test
     */
    public function getGenderReturnsInitialValueForInt()
    {
        self::assertSame(
            0,
            $this->subject->getGender()
        );
    }

    /**
     * @test
     */
    public function setGenderForIntSetsGender()
    {
        $this->subject->setGender(12);

        self::assertAttributeEquals(
            12,
            'gender',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getFirstNameReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getFirstName()
        );
    }

    /**
     * @test
     */
    public function setFirstNameForStringSetsFirstName()
    {
        $this->subject->setFirstName('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'firstName',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getLastNameReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getLastName()
        );
    }

    /**
     * @test
     */
    public function setLastNameForStringSetsLastName()
    {
        $this->subject->setLastName('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'lastName',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getAddressReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getAddress()
        );
    }

    /**
     * @test
     */
    public function setAddressForStringSetsAddress()
    {
        $this->subject->setAddress('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'address',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getAddressAdditionalReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getAddressAdditional()
        );
    }

    /**
     * @test
     */
    public function setAddressAdditionalForStringSetsAddressAdditional()
    {
        $this->subject->setAddressAdditional('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'addressAdditional',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getZipCityReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getZipCity()
        );
    }

    /**
     * @test
     */
    public function setZipCityForStringSetsZipCity()
    {
        $this->subject->setZipCity('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'zipCity',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getPhoneReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getPhone()
        );
    }

    /**
     * @test
     */
    public function setPhoneForStringSetsPhone()
    {
        $this->subject->setPhone('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'phone',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getMobileReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getMobile()
        );
    }

    /**
     * @test
     */
    public function setMobileForStringSetsMobile()
    {
        $this->subject->setMobile('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'mobile',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getEmailReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getEmail()
        );
    }

    /**
     * @test
     */
    public function setEmailForStringSetsEmail()
    {
        $this->subject->setEmail('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'email',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getMessageReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getMessage()
        );
    }

    /**
     * @test
     */
    public function setMessageForStringSetsMessage()
    {
        $this->subject->setMessage('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'message',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getBirthDateReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getBirthDate()
        );
    }

    /**
     * @test
     */
    public function setBirthDateForStringSetsBirthDate()
    {
        $this->subject->setBirthDate('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'birthDate',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getApplicationLetterReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getApplicationLetter()
        );
    }

    /**
     * @test
     */
    public function setApplicationLetterForStringSetsApplicationLetter()
    {
        $this->subject->setApplicationLetter('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'applicationLetter',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getCurriculumVitaeReturnsInitialValueForFileReference()
    {
        self::assertEquals(
            null,
            $this->subject->getCurriculumVitae()
        );
    }

    /**
     * @test
     */
    public function setCurriculumVitaeForFileReferenceSetsCurriculumVitae()
    {
        $fileReferenceFixture = new \TYPO3\CMS\Extbase\Domain\Model\FileReference();
        $this->subject->setCurriculumVitae($fileReferenceFixture);

        self::assertAttributeEquals(
            $fileReferenceFixture,
            'curriculumVitae',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getJobReferencesReturnsInitialValueForFileReference()
    {
        self::assertEquals(
            null,
            $this->subject->getJobReferences()
        );
    }

    /**
     * @test
     */
    public function setJobReferencesForFileReferenceSetsJobReferences()
    {
        $fileReferenceFixture = new \TYPO3\CMS\Extbase\Domain\Model\FileReference();
        $this->subject->setJobReferences($fileReferenceFixture);

        self::assertAttributeEquals(
            $fileReferenceFixture,
            'jobReferences',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getDiplomasReturnsInitialValueForFileReference()
    {
        self::assertEquals(
            null,
            $this->subject->getDiplomas()
        );
    }

    /**
     * @test
     */
    public function setDiplomasForFileReferenceSetsDiplomas()
    {
        $fileReferenceFixture = new \TYPO3\CMS\Extbase\Domain\Model\FileReference();
        $this->subject->setDiplomas($fileReferenceFixture);

        self::assertAttributeEquals(
            $fileReferenceFixture,
            'diplomas',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getFile1ReturnsInitialValueForFileReference()
    {
        self::assertEquals(
            null,
            $this->subject->getFile1()
        );
    }

    /**
     * @test
     */
    public function setFile1ForFileReferenceSetsFile1()
    {
        $fileReferenceFixture = new \TYPO3\CMS\Extbase\Domain\Model\FileReference();
        $this->subject->setFile1($fileReferenceFixture);

        self::assertAttributeEquals(
            $fileReferenceFixture,
            'file1',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getFile2ReturnsInitialValueForFileReference()
    {
        self::assertEquals(
            null,
            $this->subject->getFile2()
        );
    }

    /**
     * @test
     */
    public function setFile2ForFileReferenceSetsFile2()
    {
        $fileReferenceFixture = new \TYPO3\CMS\Extbase\Domain\Model\FileReference();
        $this->subject->setFile2($fileReferenceFixture);

        self::assertAttributeEquals(
            $fileReferenceFixture,
            'file2',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getFile3ReturnsInitialValueForFileReference()
    {
        self::assertEquals(
            null,
            $this->subject->getFile3()
        );
    }

    /**
     * @test
     */
    public function setFile3ForFileReferenceSetsFile3()
    {
        $fileReferenceFixture = new \TYPO3\CMS\Extbase\Domain\Model\FileReference();
        $this->subject->setFile3($fileReferenceFixture);

        self::assertAttributeEquals(
            $fileReferenceFixture,
            'file3',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getFile4ReturnsInitialValueForFileReference()
    {
        self::assertEquals(
            null,
            $this->subject->getFile4()
        );
    }

    /**
     * @test
     */
    public function setFile4ForFileReferenceSetsFile4()
    {
        $fileReferenceFixture = new \TYPO3\CMS\Extbase\Domain\Model\FileReference();
        $this->subject->setFile4($fileReferenceFixture);

        self::assertAttributeEquals(
            $fileReferenceFixture,
            'file4',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getApplicationLetterFileReturnsInitialValueForFileReference()
    {
        self::assertEquals(
            null,
            $this->subject->getApplicationLetterFile()
        );
    }

    /**
     * @test
     */
    public function setApplicationLetterFileForFileReferenceSetsApplicationLetterFile()
    {
        $fileReferenceFixture = new \TYPO3\CMS\Extbase\Domain\Model\FileReference();
        $this->subject->setApplicationLetterFile($fileReferenceFixture);

        self::assertAttributeEquals(
            $fileReferenceFixture,
            'applicationLetterFile',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getPositionReturnsInitialValueForPosition()
    {
        self::assertEquals(
            null,
            $this->subject->getPosition()
        );
    }

    /**
     * @test
     */
    public function setPositionForPositionSetsPosition()
    {
        $positionFixture = new \Ig\IgJobs\Domain\Model\Position();
        $this->subject->setPosition($positionFixture);

        self::assertAttributeEquals(
            $positionFixture,
            'position',
            $this->subject
        );
    }
}
