<?php
namespace Ig\IgJobs\Tests\Unit\Domain\Model;

/**
 * Test case.
 *
 * @author Simon Häsler <sh@internetgalerie.ch>
 */
class PositionTest extends \TYPO3\CMS\Core\Tests\UnitTestCase
{
    /**
     * @var \Ig\IgJobs\Domain\Model\Position
     */
    protected $subject = null;

    protected function setUp()
    {
        parent::setUp();
        $this->subject = new \Ig\IgJobs\Domain\Model\Position();
    }

    protected function tearDown()
    {
        parent::tearDown();
    }

    /**
     * @test
     */
    public function getTitleReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getTitle()
        );
    }

    /**
     * @test
     */
    public function setTitleForStringSetsTitle()
    {
        $this->subject->setTitle('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'title',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getPositionNoReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getPositionNo()
        );
    }

    /**
     * @test
     */
    public function setPositionNoForStringSetsPositionNo()
    {
        $this->subject->setPositionNo('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'positionNo',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getLevelOfEmploymentReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getLevelOfEmployment()
        );
    }

    /**
     * @test
     */
    public function setLevelOfEmploymentForStringSetsLevelOfEmployment()
    {
        $this->subject->setLevelOfEmployment('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'levelOfEmployment',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getRegionReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getRegion()
        );
    }

    /**
     * @test
     */
    public function setRegionForStringSetsRegion()
    {
        $this->subject->setRegion('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'region',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getDescriptionReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getDescription()
        );
    }

    /**
     * @test
     */
    public function setDescriptionForStringSetsDescription()
    {
        $this->subject->setDescription('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'description',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getApplicationTextReturnsInitialValueForBool()
    {
        self::assertSame(
            false,
            $this->subject->getApplicationText()
        );
    }

    /**
     * @test
     */
    public function setApplicationTextForBoolSetsApplicationText()
    {
        $this->subject->setApplicationText(true);

        self::assertAttributeEquals(
            true,
            'applicationText',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getStartdateReturnsInitialValueForDateTime()
    {
        self::assertEquals(
            null,
            $this->subject->getStartdate()
        );
    }

    /**
     * @test
     */
    public function setStartdateForDateTimeSetsStartdate()
    {
        $dateTimeFixture = new \DateTime();
        $this->subject->setStartdate($dateTimeFixture);

        self::assertAttributeEquals(
            $dateTimeFixture,
            'startdate',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getEnddateReturnsInitialValueForDateTime()
    {
        self::assertEquals(
            null,
            $this->subject->getEnddate()
        );
    }

    /**
     * @test
     */
    public function setEnddateForDateTimeSetsEnddate()
    {
        $dateTimeFixture = new \DateTime();
        $this->subject->setEnddate($dateTimeFixture);

        self::assertAttributeEquals(
            $dateTimeFixture,
            'enddate',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getPdfReturnsInitialValueForFileReference()
    {
        self::assertEquals(
            null,
            $this->subject->getPdf()
        );
    }

    /**
     * @test
     */
    public function setPdfForFileReferenceSetsPdf()
    {
        $fileReferenceFixture = new \TYPO3\CMS\Extbase\Domain\Model\FileReference();
        $this->subject->setPdf($fileReferenceFixture);

        self::assertAttributeEquals(
            $fileReferenceFixture,
            'pdf',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getEmploymentReturnsInitialValueForEmployment()
    {
        self::assertEquals(
            null,
            $this->subject->getEmployment()
        );
    }

    /**
     * @test
     */
    public function setEmploymentForEmploymentSetsEmployment()
    {
        $employmentFixture = new \Ig\IgJobs\Domain\Model\Employment();
        $this->subject->setEmployment($employmentFixture);

        self::assertAttributeEquals(
            $employmentFixture,
            'employment',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getCategoriesReturnsInitialValueForCategory()
    {
        $newObjectStorage = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        self::assertEquals(
            $newObjectStorage,
            $this->subject->getCategories()
        );
    }

    /**
     * @test
     */
    public function setCategoriesForObjectStorageContainingCategorySetsCategories()
    {
        $category = new \Ig\IgJobs\Domain\Model\Category();
        $objectStorageHoldingExactlyOneCategories = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $objectStorageHoldingExactlyOneCategories->attach($category);
        $this->subject->setCategories($objectStorageHoldingExactlyOneCategories);

        self::assertAttributeEquals(
            $objectStorageHoldingExactlyOneCategories,
            'categories',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function addCategoryToObjectStorageHoldingCategories()
    {
        $category = new \Ig\IgJobs\Domain\Model\Category();
        $categoriesObjectStorageMock = $this->getMockBuilder(\TYPO3\CMS\Extbase\Persistence\ObjectStorage::class)
            ->setMethods(['attach'])
            ->disableOriginalConstructor()
            ->getMock();

        $categoriesObjectStorageMock->expects(self::once())->method('attach')->with(self::equalTo($category));
        $this->inject($this->subject, 'categories', $categoriesObjectStorageMock);

        $this->subject->addCategory($category);
    }

    /**
     * @test
     */
    public function removeCategoryFromObjectStorageHoldingCategories()
    {
        $category = new \Ig\IgJobs\Domain\Model\Category();
        $categoriesObjectStorageMock = $this->getMockBuilder(\TYPO3\CMS\Extbase\Persistence\ObjectStorage::class)
            ->setMethods(['detach'])
            ->disableOriginalConstructor()
            ->getMock();

        $categoriesObjectStorageMock->expects(self::once())->method('detach')->with(self::equalTo($category));
        $this->inject($this->subject, 'categories', $categoriesObjectStorageMock);

        $this->subject->removeCategory($category);
    }
}
