let navi_top = function () {
    let container = document.getElementById('header');
    let buttonContainerPos = container.offsetTop;
    let lastScrollTop = 0;
    checkContainerPos();

    function onScroll() {
        let st = window.pageYOffset || document.documentElement.scrollTop;
        if (st > lastScrollTop) {
            // scroll down
            container.classList.remove('show');
        } else {
            // scroll up
            container.classList.add('show');
        }
        checkContainerPos();
        lastScrollTop = st;
    }

    function checkContainerPos() {
        buttonContainerPos = container.offsetTop;
        let containerHeight = container.offsetHeight;
        if (window.pageYOffset >= buttonContainerPos + containerHeight) {
            container.classList.add('fixed');
        }
        if (window.pageYOffset === 0 || window.pageYOffset < buttonContainerPos) {
            container.classList.remove('fixed', 'show');
        }
    }

    window.addEventListener('scroll', () => {
        requestAnimationFrame(onScroll);
    });
};

navi_top();