<?php

declare(strict_types=1);

namespace Internetgalerie\IgLoginas\Controller;

use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Database\Query\Restriction\DeletedRestriction;
use TYPO3\CMS\Core\Error\Exception;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

class SwitchController extends ActionController
{
    /**
     * action switch
     */
    public function switchAction(int $uid = 0): ResponseInterface
    {
        $enableFrontendUserSwitch = (int)$this->settings['enableFrontendUserSwitch'];
        if (!$enableFrontendUserSwitch) {
            throw new Exception('Not authorized to switch user.', 1574892512);
        }

        // Debug
        //$uid = 1313; // b81005   - jenzer
        //$uid = 1425;// steck756
        //$uid = 23;// //pedosadmin

        if ($uid > 0) {
            $context = GeneralUtility::makeInstance(Context::class);
            $frontendUserGroupIds = $context->getPropertyFromAspect('frontend.user', 'groupIds');
            //$frontendUserAuthentication = $GLOBALS['TSFE']->fe_user;
            $frontendUserAuthentication = $this->request->getAttribute('frontend.user');
            //$frontendUserGroups = array_values($frontendUserAuthentication->groupData['uid']);
        
            // Only switch user when originally had logged in as member of "administrators" or else if user had already been switched before
            //  || $frontendUserAuthentication->getKey('ses', 'tx_ext_originuser') > 0)
            $uidsUserGroupAdministrators = GeneralUtility::intExplode(
                ',',
                $this->settings['uidUserGroupAdministrators'],
                true
            );
            if ($this->settings['uidUserGroupAdministrators'] != '' && in_array(
                $this->settings['uidUserGroupAdministrators'],
                $frontendUserGroupIds
            )) {
                // Store uid of origin user in session to be able to switch back to it later or to do any additional switching
                /*
                  if(!$frontendUserAuthentication->getKey('ses', 'tx_ext_originuser')) {
                  $frontendUserAuthentication->setKey('ses', 'tx_ext_originuser', $frontendUserAuthentication->user['uid']);
                  $frontendUserAuthentication->storeSessionData();
                  }
                */
                //var_dump($frontendUserAuthentication);exit(0);
                // Set new user
                $frontendUserAuthentication->checkPid = false;
                //$frontendUserAuthentication->setBeUserByUid($uid);
                $frontendUserDataRaw = $this->fetchFrontendUserDataRaw($uid);
                //$frontendUserAuthentication->user = $frontendUserDataRaw;
                $frontendUserAuthentication->createUserSession($frontendUserDataRaw);
                $frontendUserAuthentication->enforceNewSessionId();
                //$frontendUserAuthentication->storeSessionData();

                $this->addFlashMessage(
                    'FrontendUser has successfully been switched.',
                    '',
                    ContextualFeedbackSeverity::OK,
                    true
                );
            }
        }

        $redirectPid = (int)$this->settings['redirectPid'];
        if ($this->request->hasArgument('returnUrl')) {
            $uri = $this->request->getArgument('returnUrl');
        } elseif ($redirectPid) {
            $uri = $this->uriBuilder->reset()
                                    ->setRequest($this->request)
                                    ->setTargetPageUid($redirectPid)
                                    ->build();
        } else {
            $uri = '/';
        }
        return $this->redirectToUri($uri);
    }

    /**
     * action showFrontendUserSwitch
     */
    /*
    public function showFrontendUserSwitchAction() {
        $showFrontendUserSwitch = false;
        $frontendUserAuthentication = $GLOBALS['TSFE']->fe_user;
        $frontendUserGroups = array_values($frontendUserAuthentication->groupData['uid']);
        // Set flag for fluid view to show or not to show frontend user switch
        if($this->settings['enableFrontendUserSwitch'] == 1 && (in_array($this->settings['uidUserGroupAdministrators'], $frontendUserGroups) || $frontendUserAuthentication->getKey('ses', 'tx_ext_originuser') > 0)) {
            $showFrontendUserSwitch = true;
        }
        // Fetch some users for fluid view to generate a switching navigation or similar based on them
        $frontendUsers['administrators'] = $this->frontendUsersRepository->findByUserGroupAdministrators();
        $frontendUsers['sales'] = $this->frontendUsersRepository->findByUserGroupSales();
        $frontendUsers['support'] = $this->frontendUsersRepository->findByUserGroupSupport();
        $this->view->assign('frontendUsers', $frontendUsers);
        $this->view->assign('showFrontendUserSwitch', $showFrontendUserSwitch);
    }
     */
    
    /**
     * fetch frontend user data raw
     */
    private function fetchFrontendUserDataRaw(int $uid): array
    {
        $query = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('fe_users');
        $query
            ->getRestrictions()
            ->removeAll()
            ->add(GeneralUtility::makeInstance(DeletedRestriction::class));
        $query
            ->select('*')
            ->from('fe_users')
            ->andWhere($query->expr() ->eq('uid', $query->createNamedParameter($uid)));
        return $query->executeQuery()
->fetchAssociative();
    }
}
