<?php
 
declare(strict_types=1);
 
namespace Ig\IgLoginas\Updates;
 
use TYPO3\CMS\Install\Updates\AbstractListTypeToCTypeUpdate;
use TYPO3\CMS\Install\Attribute\UpgradeWizard;
 
#[UpgradeWizard('igLoginasCTypeMigration')]
final class IgLoginasCTypeMigration extends AbstractListTypeToCTypeUpdate
{
    protected function getListTypeToCTypeMapping(): array
    {
        return ['igloginas_loginas' => 'igloginas_loginas'];
    }
 
    public function getTitle(): string
    {
        return 'Migrate "Ig Loginas" plugins to content elements.';
    }
 
    public function getDescription(): string
    {
        return 'The "Ig Loginas" plugin is now registered as content element. Update migrates existing records and backend user permissions.';
    }
 
}