<?php

namespace Internetgalerie\IgMailMarkers\EventListener;

use MEDIAESSENZ\Mail\Events\ManipulateMarkersEvent;

final class IgSalutationEventListener extends AbstractMailMarkersEventListener
{
    protected array $possibleKeys = [
        '###IG_salutation###',
        '###IG_SALUTATION###'
    ];
    
    public function __invoke(ManipulateMarkersEvent $event): void
    {
        parent::__invoke($event);

        $title = $this->recipient['title'] ?? '';
        $gender = $this->recipient['gender'] ?? '';
        $lastName = $this->recipient['last_name'] ?? '';

        $salutationParts = [];

        if (!empty($title)) {
            $salutationParts[] = $title;
        } else {
            if (!empty($lastName)) {
                if (!empty($gender)) {
                    $salutationParts[] = $this->translate('salutation.' . $gender);
                }
                $salutationParts[] = $lastName;
            } else {
                $salutationParts[] = $this->translate('salutation.g') ?? '';
            }
        }

        $salutation = trim(implode(' ', array_filter($salutationParts)));
        $this->setMarkers($salutation);
    }
}
