<?php

namespace Internetgalerie\IgMailMarkers\EventListener;

use MEDIAESSENZ\Mail\Events\ManipulateMarkersEvent;

final class IgSalutationInformalEventListener extends AbstractMailMarkersEventListener
{
    protected array $possibleKeys = [
        '###IG_salutation_informal###',
        '###IG_SALUTATION_INFORMAL###'
    ];

    public function __invoke(ManipulateMarkersEvent $event): void
    {
        parent::__invoke($event);

        $title = $this->recipient['title'] ?? '';
        $gender = $this->recipient['gender'] ?? '';
        $lastName = $this->recipient['last_name'] ?? '';

        $salutationParts = [];

        if (!empty($title)) {
            $salutationParts[] = $title;
        } else {
            if (!empty($lastName)) {
                if (!empty($gender)) {
                    $salutationParts[] = $this->translate('salutation.informal.' . $gender);
                }
                $salutationParts[] = $lastName;
            } else {
                $salutationParts[] = $this->translate('salutation.informal.g') ?? '';
            }
        }

        $salutation = trim(implode(' ', array_filter($salutationParts)));
        $this->setMarkers($salutation);
    }
}
